/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers.core;

import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.core.SeqReaderCore;
import edu.msu.cme.rdp.readseq.sequences.GenbankSequence;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EMBLCore
extends SeqReaderCore {
    public EMBLCore(File seqFile) throws IOException {
        super(seqFile);
    }

    public EMBLCore(InputStream is) throws IOException {
        super(is);
    }

    @Override
    public Map<String, Long> scanInternal() throws IOException {
        RandomAccessFile seqFile = super.getRawFile();
        seqFile.seek(0L);
        long firstHeader = seqFile.getFilePointer();
        long lastHeader = seqFile.getFilePointer();
        LinkedHashMap<String, Long> seqIndex = new LinkedHashMap<String, Long>();
        while (seqFile.getFilePointer() != seqFile.length()) {
            String sid = this.parseSid();
            seqIndex.put(sid, lastHeader);
            this.readUntilNext("\n//");
            lastHeader = seqFile.getFilePointer();
        }
        seqFile.seek(firstHeader);
        return seqIndex;
    }

    public int scanToStream(DataOutputStream out) throws IOException {
        RandomAccessFile seqFile = super.getRawFile();
        seqFile.seek(0L);
        long firstHeader = seqFile.getFilePointer();
        long lastHeader = seqFile.getFilePointer();
        LinkedHashMap seqIndex = new LinkedHashMap();
        out.writeLong(seqFile.length());
        out.writeUTF(SequenceFormat.EMBL.toString());
        int written = 0;
        while (seqFile.getFilePointer() != seqFile.length()) {
            String sid = this.parseSid();
            out.writeUTF(sid);
            out.writeLong(lastHeader);
            ++written;
            this.readUntilNext("\n//");
            lastHeader = seqFile.getFilePointer();
        }
        out.close();
        seqFile.seek(firstHeader);
        return written;
    }

    @Override
    public Sequence readNextSeq() throws IOException {
        String line;
        String seqid = null;
        String desc = "";
        String seqString = null;
        String organism = "";
        HashMap<String, Map<String, String>> featureTable = new HashMap<String, Map<String, String>>();
        HashMap<String, String> features = null;
        while ((line = this.readUntilNext('\n')) != null && !(line = line.trim()).equals("//")) {
            if (line.isEmpty()) continue;
            String[] lexemes = line.split("\\s+");
            if (lexemes[0].equals("ID")) {
                seqid = lexemes[1].split(";")[0];
                continue;
            }
            if (lexemes[0].equals("DE")) {
                if (!desc.isEmpty()) {
                    desc = desc + " ";
                }
                desc = desc + line.substring(2).trim();
                continue;
            }
            if (lexemes[0].equals("OS")) {
                if (!organism.isEmpty()) {
                    organism = organism + " ";
                }
                organism = organism + line.substring(2).trim();
                continue;
            }
            if (lexemes[0].equals("SQ")) {
                seqString = this.parseSeq();
                break;
            }
            if (!lexemes[0].equals("FT")) continue;
            if (lexemes[1].charAt(0) == '/') {
                String qual = line.substring(2).trim();
                if (!qual.endsWith("\"") && qual.contains("\"")) {
                    String rest = this.readUntilNext("\"\n");
                    for (String s : rest.split("\n")) {
                        qual = qual + s.substring(2).trim();
                    }
                }
                if ((lexemes = qual.replace("\"", "").substring(1).split("=")).length != 2) {
                    throw new IOException("Malformed qualifier " + qual + " in record " + seqid);
                }
                features.put(lexemes[0], lexemes[1]);
                continue;
            }
            if (lexemes.length == 3) {
                features = new HashMap<String, String>();
                features.put("location", lexemes[2]);
                featureTable.put(lexemes[1], features);
                continue;
            }
            throw new IOException("Malformed qualifier " + line + " in record " + seqid);
        }
        if (seqid == null) {
            return null;
        }
        return new GenbankSequence(seqid, desc, organism, featureTable, seqString.replaceAll("\\s+", ""));
    }

    private String parseSid() throws IOException {
        return this.readUntilNext(' ', '\t', '\n', '\r');
    }

    private String parseSeq() throws IOException {
        StringBuilder retSeq = new StringBuilder();
        String seq = this.readUntilNext("//");
        if (seq == null) {
            return null;
        }
        seq = seq.trim();
        for (String line : seq.split("\n")) {
            if ((line = line.trim()).isEmpty()) continue;
            int idx = line.lastIndexOf(" ");
            if (idx == -1) {
                Logger.getLogger(this.getClass().getCanonicalName()).log(Level.WARNING, "Weird sequence parsing seqbuffer={0}, currseq={1}", new Object[]{seq, retSeq});
                continue;
            }
            retSeq.append(line.substring(0, idx));
        }
        return retSeq.toString();
    }

    public static void main(String[] args) throws IOException {
        EMBLCore tmp = new EMBLCore(new File(args[0]));
        GenbankSequence seq = (GenbankSequence)tmp.readNextSeq();
        System.out.println(seq.getSeqName());
        System.out.println(seq.getDesc());
        System.out.println(seq.getOrganism());
        System.out.println(seq.getFeatureTable());
        System.out.println(seq.getSeqString());
    }
}

