/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers.core;

import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.core.SeqReaderCore;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenbankCore
extends SeqReaderCore {
    public GenbankCore(File seqFile) throws IOException {
        super(seqFile);
    }

    public GenbankCore(InputStream is) throws IOException {
        super(is);
    }

    @Override
    public Map<String, Long> scanInternal() throws IOException {
        RandomAccessFile seqFile = super.getRawFile();
        seqFile.seek(0L);
        long firstHeader = seqFile.getFilePointer();
        long lastHeader = seqFile.getFilePointer();
        LinkedHashMap<String, Long> seqIndex = new LinkedHashMap<String, Long>();
        while (seqFile.getFilePointer() != seqFile.length()) {
            String sid = this.parseSid();
            seqIndex.put(sid, lastHeader);
            this.readUntilNext("\n//");
            lastHeader = seqFile.getFilePointer();
        }
        seqFile.seek(firstHeader);
        return seqIndex;
    }

    public int scanToStream(DataOutputStream out) throws IOException {
        RandomAccessFile seqFile = super.getRawFile();
        seqFile.seek(0L);
        long firstHeader = seqFile.getFilePointer();
        long lastHeader = seqFile.getFilePointer();
        out.writeLong(seqFile.length());
        out.writeUTF(SequenceFormat.GENBANK.toString());
        int written = 0;
        while (seqFile.getFilePointer() != seqFile.length()) {
            String sid = this.parseSid();
            out.writeUTF(sid);
            out.writeLong(lastHeader);
            ++written;
            this.readUntilNext("\n//");
            lastHeader = seqFile.getFilePointer();
        }
        out.close();
        seqFile.seek(firstHeader);
        return written;
    }

    @Override
    public Sequence readNextSeq() throws IOException {
        String line;
        String seqid = null;
        String desc = "";
        String seqString = null;
        while ((line = this.readUntilNext('\n')) != null && !(line = line.trim()).equals("//")) {
            if (line.isEmpty()) continue;
            String[] lexemes = line.split("\\s+");
            if (lexemes[0].equals("LOCUS")) {
                seqid = lexemes[1].split(";")[0];
                continue;
            }
            if (lexemes[0].equals("DEFINITION")) {
                if (!desc.isEmpty()) {
                    desc = desc + " ";
                }
                desc = desc + line.substring(2).trim();
                continue;
            }
            if (!lexemes[0].equals("ORIGIN")) continue;
            seqString = this.parseSeq();
            break;
        }
        if (seqid == null) {
            return null;
        }
        if (seqString == null) {
            seqString = "";
        }
        return new Sequence(seqid, desc, seqString.replaceAll("\\s+", ""));
    }

    private String parseSid() throws IOException {
        return this.readUntilNext(' ', '\t', '\n', '\r');
    }

    private String parseSeq() throws IOException {
        StringBuilder retSeq = new StringBuilder();
        String seq = this.readUntilNext("//");
        if (seq == null) {
            return "";
        }
        seq = seq.trim();
        for (String line : seq.split("\n")) {
            int idx = (line = line.trim()).indexOf(" ");
            if (idx == -1) {
                Logger.getLogger(this.getClass().getCanonicalName()).log(Level.WARNING, "Weird sequence parsing seqbuffer={0}, currseq={1}", new Object[]{seq, retSeq});
                continue;
            }
            retSeq.append(line.substring(idx));
        }
        return retSeq.toString();
    }
}

