/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier;

import edu.msu.cme.rdp.classifier.ClassificationResult;
import edu.msu.cme.rdp.classifier.Classifier;
import edu.msu.cme.rdp.classifier.ShortSequenceException;
import edu.msu.cme.rdp.classifier.TrainingDataException;
import edu.msu.cme.rdp.classifier.cli.CmdOptions;
import edu.msu.cme.rdp.classifier.io.ClassificationResultFormatter;
import edu.msu.cme.rdp.classifier.utils.ClassifierFactory;
import edu.msu.cme.rdp.classifier.utils.ClassifierSequence;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class ClassifierCmd {
    private static final Options options = new Options();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClassify(String inputFile, String outFile, String propfile, ClassificationResultFormatter.FORMAT format, String gene, int min_bootstrap_words) throws IOException, TrainingDataException {
        if (propfile != null) {
            ClassifierFactory.setDataProp(propfile, false);
        }
        if (format == null) {
            format = CmdOptions.DEFAULT_FORMAT;
        }
        ClassifierFactory factory = ClassifierFactory.getFactory(gene);
        Classifier aClassifier = factory.createClassifier();
        SequenceReader parser = new SequenceReader(new File(inputFile));
        BufferedWriter wt = new BufferedWriter(new FileWriter(outFile));
        Sequence pSeq = null;
        try {
            while ((pSeq = parser.readNextSequence()) != null) {
                try {
                    ClassificationResult result = aClassifier.classify(new ClassifierSequence(pSeq), min_bootstrap_words);
                    wt.write(ClassificationResultFormatter.getOutput(result, format));
                }
                catch (ShortSequenceException e) {
                    System.out.println(e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            wt.close();
        }
    }

    public static void printLicense() {
        String license = "Copyright 2006-2011 Michigan State University Board of Trustees.\n\nThis program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA\n\nAuthors's mailng address:\nCenter for Microbial Ecology\n2225A Biomedical Physical Science\nMichigan State University\nEast Lansing, Michigan USA 48824-4320\nE-mail: James R. Cole at colej@msu.edu\n\tQiong Wang at wangqion@msu.edu\n\tJames M. Tiedje at tiedjej@msu.edu\n\n";
        System.err.println(license);
    }

    public static void main(String[] args) throws Exception {
        String queryFile = null;
        String outputFile = null;
        String propFile = null;
        String gene = null;
        ClassificationResultFormatter.FORMAT format = CmdOptions.DEFAULT_FORMAT;
        int min_bootstrap_words = 5;
        try {
            CommandLine line = new PosixParser().parse(options, args);
            if (!line.hasOption("o")) {
                throw new Exception("outputFile must be specified");
            }
            outputFile = line.getOptionValue("o");
            if (line.hasOption("t")) {
                if (gene != null) {
                    throw new IllegalArgumentException("Already specified the gene from the default location. Can not specify train_propfile");
                }
                propFile = line.getOptionValue("t");
            }
            if (line.hasOption("f")) {
                String f = line.getOptionValue("f");
                if (f.equalsIgnoreCase("allrank")) {
                    format = ClassificationResultFormatter.FORMAT.allRank;
                } else if (f.equalsIgnoreCase("fixrank")) {
                    format = ClassificationResultFormatter.FORMAT.fixRank;
                } else if (f.equalsIgnoreCase("filterbyconf")) {
                    format = ClassificationResultFormatter.FORMAT.filterbyconf;
                } else if (f.equalsIgnoreCase("db")) {
                    format = ClassificationResultFormatter.FORMAT.dbformat;
                } else {
                    throw new IllegalArgumentException("Not valid output format, only allrank, fixrank, filterbyconf and db allowed");
                }
            }
            if (line.hasOption("g")) {
                if (propFile != null) {
                    throw new IllegalArgumentException("Already specified train_propfile. Can not specify gene any more");
                }
                gene = line.getOptionValue("g").toLowerCase();
                if (!gene.equals("16srrna") && !gene.equals("fungallsu")) {
                    throw new IllegalArgumentException(gene + " is NOT valid, only allows " + "16srrna" + " and " + "fungallsu");
                }
            }
            if (line.hasOption("w") && (min_bootstrap_words = Integer.parseInt(line.getOptionValue("w"))) < 5) {
                throw new IllegalArgumentException("minWords must be at least 5");
            }
            args = line.getArgs();
            if (args.length != 1) {
                throw new Exception("Expect one query file");
            }
            queryFile = args[0];
        }
        catch (Exception e) {
            System.out.println("Command Error: " + e.getMessage());
            new HelpFormatter().printHelp(120, "ClassifierCmd [options] <samplefile>\nNote this is the legacy command for one sample classification ", "", options, "");
            return;
        }
        if (propFile == null && gene == null) {
            gene = CmdOptions.DEFAULT_GENE;
        }
        ClassifierCmd classifierCmd = new ClassifierCmd();
        ClassifierCmd.printLicense();
        classifierCmd.doClassify(queryFile, outputFile, propFile, format, gene, min_bootstrap_words);
    }

    static {
        options.addOption(new Option("q", "queryFile", false, "legacy option, no longer needed "));
        options.addOption(new Option("o", "outputFile", true, "tab-delimited text output file for classification assignment."));
        options.addOption(new Option("t", "train_propfile", true, "property file containing the mapping of the training files if not using the default. Note: the training files and the property file should be in the same directory."));
        options.addOption(new Option("f", "format", true, CmdOptions.FORMAT_DESC));
        options.addOption(new Option("g", "gene", true, CmdOptions.GENE_DESC));
        options.addOption(new Option("w", "minWords", true, "minimum number of words for each bootstrap trial. Default(maximum) is 1/8 of the words of each sequence. Minimum is 5"));
    }
}

