% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explained_variation.R
\name{EV_table}
\alias{EV_table}
\title{EV Table
Returns table with percent variation explained for specified number of genes}
\usage{
EV_table(batchqc_ev)
}
\arguments{
\item{batchqc_ev}{explained variation results from
batchqc_explained_variation}
}
\value{
List of explained variation by batch and condition
}
\description{
EV Table
Returns table with percent variation explained for specified number of genes
}
\examples{
library(scran)
se <- mockSCE()
se$Mutation_Status <- as.factor(se$Mutation_Status)
se$Treatment <- as.factor(se$Treatment)
exp_var_result <- BatchQC::batchqc_explained_variation(se,
                                    batch = "Mutation_Status",
                                    condition = "Treatment",
                                    assay_name = "counts")
EV_table <- BatchQC::EV_table(exp_var_result[[1]])

EV_table

}
