% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Vis_pie}
\alias{Vis_pie}
\title{Pie Chart Visualization of Subtype Distribution}
\usage{
Vis_pie(out)
}
\arguments{
\item{out}{A data frame containing two columns: \code{"PatientID"} and
\code{"Subtype"}. The \code{"PatientID"} column should contain unique patient
identifiers, and the \code{"Subtype"} column should specify the assigned subtype
for each patient.}
}
\value{
A \code{ggplot} object representing a pie chart showing the proportion of
each subtype in the dataset.
}
\description{
This function generates a pie chart to visualize the
distribution of breast cancer subtypes in a cohort, based on the provided
\code{Subtype} data.
}
\examples{
data("OSLO2EMIT0obj")
res <- OSLO2EMIT0obj$res

# Prepare data: Subtype information
out <- data.frame(
    PatientID = res$results$genefu.robust$BS.all$PatientID,
    Subtype = res$results$genefu.robust$BS.all$BS
)

# Generate the pie chart
p <- Vis_pie(out = out)
plot(p)

}
