% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcbn.R
\name{hcbn}
\alias{hcbn}
\title{H-CBN}
\usage{
hcbn(
  datasets,
  anneal = FALSE,
  temp = 0,
  annealingSteps = 0,
  epsilon = 2,
  nCores = 1
)
}
\arguments{
\item{datasets}{Vector of \code{Spock} objects with poset and pattern/lambda data or a \code{Spock} object (alias of hcbnSingle).}

\item{anneal}{If \code{TRUE}, performes a simulated annealing run starting from the poset}

\item{temp}{Temperature of simulated annealing.}

\item{annealingSteps}{Number of simulated annealing steps.}

\item{epsilon}{Value of eps for CT-CBN model selection. Requires both pattern and lambda data in input \code{Spock}.}

\item{nCores}{Maximum number of threads to use to parallelize.}
}
\value{
A matrix of results.
}
\description{
H-CBN
}
\examples{
examplePath <- getExamples()[3]
bc <- Spock$new(
    poset = readPoset(examplePath)$sets,
    numMutations = readPoset(examplePath)$mutations,
    genotypeMatrix = readPattern(examplePath)
)
hcbn(bc)
hcbn(c(bc, bc, bc))
}
