% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_overlaps.R
\name{cellSetsOverlaps}
\alias{cellSetsOverlaps}
\title{Calculates the significance of overlaps of pairs of cells sets}
\usage{
cellSetsOverlaps(cellSets, nCells, pairs = NULL, overlapFileName = NULL)
}
\arguments{
\item{cellSets}{A list of character arrays.}

\item{nCells}{The total number of cells in the Seurat object.}

\item{pairs}{Pairs of cell sets to be assessed. If \code{NULL} (as default),
all pairs will be assessed.}

\item{overlapFileName}{The name of the file where the overlap data frame
will be saved. This option can be used to save time when performing
exploratory analyses such as trying different \code{jaccardCutoff} parameters
in \code{breakWeakTies}. Default is \code{NULL} (the overlap data frame will
not be saved).}
}
\value{
A data frame listing statistics for all cell set overlaps: cell set
sizes, recorded and expected shared cells, the recorded-over-expected ratio
and the hypergeometric p-value.
}
\description{
This function computes the statistical significance of overlaps of pairs of
cell sets.
}
\examples{
cellSets <- list(G1 = c('A', 'H', 'J'),
G2 = c('B', 'D', 'E', 'F', 'J'),
G3 = c('C', 'I', 'L'))
cellSetsOverlaps(cellSets, 40)

}
