% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embryo_expression.R
\name{embryo_expression}
\alias{embryo_expression}
\title{Gene expression in human embryos}
\usage{
embryo_expression(
  dataset = c("Petropoulos", "Zhu"),
  genes = NULL,
  include_CTP = FALSE,
  scale_lims = NULL,
  values_only = FALSE
)
}
\arguments{
\item{dataset}{\code{character}. Indicates which scRNAseq dataset to use.
Either Petropoulos or Zhu, no default.}

\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT (specific) genes.}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{scale_lims}{\verb{vector of length 2} setting the lower and upper limits
of the heatmap colorbar. By default, the lower limit is 0, and the upper
limit corresponds to the third quartile of the logcounts values.}

\item{values_only}{\code{logical(1)}. If \code{TRUE}, the function will return the
SingleCellExperiment instead of the heatmap. Default is \code{FALSE}.}
}
\value{
A heatmap of selected CT genes expression in single cells from
embryos. If \code{values_only = TRUE}, a SingleCellExperiment is returned instead.
}
\description{
Plots a heatmap of genes expression in human early embryos,
from "Petropoulos" scRNAseq dataset ("Single-Cell RNA-Seq Reveals Lineage
and X Chromosome Dynamics in Human Preimplantation Embryos".
Petropoulos et al., Cell 2016) or from "Zhu" scRNAseq dataset ("Single-cell
DNA methylome sequencing of human preimplantation embryos". Zhu et al.
Nat genetics 2018)
}
\examples{
\dontrun{
embryo_expression(dataset = "Petropoulos", include_CTP = FALSE)
embryo_expression(dataset = "Zhu", include_CTP = FALSE)
}
}
