% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterCan.R
\name{mutFilterCan}
\alias{mutFilterCan}
\title{mutFilterCan}
\usage{
mutFilterCan(
  maf,
  cancerType,
  PONfile = NULL,
  PONformat = "vcf",
  panel = "Customized",
  tumorDP = 0,
  normalDP = 0,
  tumorAD = 0,
  normalAD = Inf,
  VAF = 0,
  VAFratio = 0,
  dbsnpCutoff = 0,
  nonCutoff = 0,
  SBmethod = "SOR",
  SBscore = Inf,
  maxIndelLen = Inf,
  minInterval = 0,
  tagFILTER = NULL,
  dbVAF = 0.01,
  ExAC = FALSE,
  Genomesprojects1000 = FALSE,
  ESP6500 = FALSE,
  gnomAD = FALSE,
  dbSNP = FALSE,
  keepCOSMIC = FALSE,
  keepType = "all",
  bedFile = NULL,
  bedFilter = FALSE,
  bedHeader = FALSE,
  mutFilter = FALSE,
  selectCols = FALSE,
  report = TRUE,
  reportFile = "FilterReport.html",
  reportDir = "./",
  TMB = FALSE,
  progressbar = TRUE,
  codelog = FALSE,
  codelogFile = "mutFilterCan.log",
  verbose = TRUE
)
}
\arguments{
\item{maf}{An MAF data frame.}

\item{cancerType}{Type of cancer whose filtering parameters
need to be referred to.  Options are: "COADREAD", "BRCA", "LIHC", "LAML",
"LCML", "UCEC", "UCS", "BLCA", "KIRC", "KIRP" and "STAD".}

\item{PONfile}{Panel-of-Normals files, which can be either obtained through 
GATK (https://gatk.broadinstitute.org/hc/en-us/articles/360035890631-Panel-of-Normals-PON-)
or generated by users. Should have at least four columns: CHROM, POS, REF, ALT.
Defalut: NULL.}

\item{PONformat}{The format of PON file, either "vcf" or "txt". Default: "vcf"}

\item{panel}{The sequencing panel applied on the dataset. Parameters
for \code{\link{mutFilterQual}} function are set differently for different
panels. Default: "Customized". Options: "MSKCC", "WES".}

\item{tumorDP}{Threshold of tumor total depth. Default: 0.}

\item{normalDP}{Threshold of normal total depth. Default: 0.}

\item{tumorAD}{Threshold of tumor alternative allele depth. Default:0.}

\item{normalAD}{Threshold of normal alternative allele depth. Default: Inf.}

\item{VAF}{Threshold of VAF value. Default: 0.}

\item{VAFratio}{Threshold of VAF ratio (tVAF/nVAF). Default: 0.}

\item{dbsnpCutoff}{Cutoff of normal depth for dbSNP variants. Default: 0.}

\item{nonCutoff}{Cutoff of normal depth for non-dbSNP variants. Default: 0.}

\item{SBmethod}{Method will be used to detect strand bias,
including 'SOR' and 'Fisher'. Default: 'SOR'. SOR: StrandOddsRatio
(https://gatk.broadinstitute.org/hc/en-us/articles/360041849111-
StrandOddsRatio).}

\item{SBscore}{Cutoff strand bias score used to filter variants.
Default: 0.}

\item{maxIndelLen}{Maximum length of indel accepted to be included.
Default: Inf.}

\item{minInterval}{Maximum length of interval between an SNV and an indel
accepted to be included. Default: 0.}

\item{tagFILTER}{Variants with spcific tag in the FILTER column will be kept,
Default: NULL.}

\item{dbVAF}{Threshold of VAF of certain population for variants
in database. Default: 0.}

\item{ExAC}{Whether to filter variants listed in ExAC with VAF higher than
cutoff(set in VAF parameter). Default: FALSE}

\item{Genomesprojects1000}{Whether to filter variants listed in
Genomesprojects1000 with VAF higher than cutoff(set in VAF parameter).
Default: FALSE.}

\item{ESP6500}{Whether to filter variants listed in ESP6500 with VAF higher
than cutoff(set in VAF parameter). Default: FALSE.}

\item{gnomAD}{Whether to filter variants listed in gnomAD with VAF higher
than cutoff(set in VAF parameter). Default: FALSE.}

\item{dbSNP}{Whether to filter variants listed in dbSNP. Default: FALSE.}

\item{keepCOSMIC}{Whether to keep variants in COSMIC even
they have are present in germline database. Default: FALSE.}

\item{keepType}{A group of variant classifications will be kept,
including 'exonic', 'nonsynonymous' and 'all'. Default: 'all'.}

\item{bedFile}{A file in bed format that contains region information.
Default: NULL}

\item{bedFilter}{Whether to filter the information in bed file or not, which
only leaves segments in Chr1-Ch22, ChrX and ChrY. Default: FALSE}

\item{bedHeader}{Whether the input bed file has a header or not. 
Default: FALSE.}

\item{mutFilter}{Whether to directly return a filtered MAF data frame.
If FALSE, a simulation filtration process will be run, and the original MAF
data frame with tags in CaTag column, and  a filter report will be returned.
If TRUE, a filtered MAF data frame and a filter report will be generated.
Default: FALSE}

\item{selectCols}{Columns will be contained in the filtered data frame.
By default (FALSE), the first 13 columns and 'Tumor_Sample_Barcode' column.
Or a vector contains column names will be kept.}

\item{report}{Whether to generate report automatically. Default: TRUE.}

\item{reportFile}{File name of the report. Default: 'FilterReport.html'}

\item{reportDir}{Path to the output report file. Default: './'}

\item{TMB}{Whether to calculate TMB. Default: FALSE.}

\item{progressbar}{Whether to show progress bar when running this function
Default: TRUE}

\item{codelog}{If TRUE, your code, along with the parameters you set, 
will be export in a log file. It will be convenient for users to repeat 
experiments. Default: FALSE}

\item{codelogFile}{Where to store the codelog, only useful when codelog is
set to TRUE. Default: "mutFilterCan.log"}

\item{verbose}{Whether to generate message/notification during the 
filtration process. Default: TRUE.}
}
\value{
An MAF data frame after common strategy filtration for a cancer type.

A filter report in HTML format
}
\description{
Apply common filtering strategies on a MAF data frame for 
different cancer types.
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf", package="CaMutQC"))
mafF <- mutFilterCan(maf, cancerType='BRCA', 
PONfile=system.file("extdata", "PON_test.txt", package="CaMutQC"), 
PONformat="txt", TMB=FALSE, report=FALSE)
}
