% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleLigandReceptorAnalysis.R
\name{getLigandReceptorPairsInPanel}
\alias{getLigandReceptorPairsInPanel}
\title{This functions takes an Seurat object, its species
and a ligand receptor network and subsets the ligand
receptor network to those pairs that occur in the
panel}
\usage{
getLigandReceptorPairsInPanel(
  obj,
  species,
  lrn = getLigandReceptorNetwork(species)
)
}
\arguments{
\item{obj}{\itemize{
\item a Seurat object or SingleCellExperiment to
be converted to a Seurat object
}}

\item{species}{\itemize{
\item either 'human' or 'mouse'
}}

\item{lrn}{\itemize{
\item a ligand-receptor network, i.e., a
data frame with columns from and to.  By default, it
retrieves the nichenetr ligand receptor network
}}
}
\value{
This returns a data frame with columns ligand and
receptor
}
\description{
This functions takes an Seurat object, its species
and a ligand receptor network and subsets the ligand
receptor network to those pairs that occur in the
panel
}
\examples{
smallXenium = make.getExample()('smallXenium')
lrPairs = getLigandReceptorPairsInPanel(smallXenium, "mouse")
}
