% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNeighbourhoods.R
\name{neighbourhoodDiameter}
\alias{neighbourhoodDiameter}
\title{neighbourhoodDiameter}
\usage{
neighbourhoodDiameter(neighbourhoods, centroids)
}
\arguments{
\item{neighbourhoods}{\itemize{
\item a list of neighbourhoods as
returned by nbhdsAsEdgesToNbhdsAsList
}}

\item{centroids}{\itemize{
\item the centroids of the cells
}}
}
\value{
a named numeric.  The names are the names
of the list neighbourhoods and the values are the
maximum distance within each neighbourhood
}
\description{
This function takes a list of neighbourhoods and and the
centroids of the cells and finds their diameters, i.e.,
for each neighbourhood, the maximum distance between.
}
\examples{
getExample = make.getExample()
centroids = getExample('centroids')
delaunayNeighbours = getExample('delaunayNeighbours')
cells = unique(c(delaunayNeighbours[,'nodeA'],delaunayNeighbours[,'nodeB']))
nbhds = nbhdsAsEdgesToNbhdsAsList(cells,delaunayNeighbours)
diameters = neighbourhoodDiameter(nbhds[seq_len(100)],centroids)
}
