% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleLigandReceptorAnalysis.R
\name{performLigandReceptorAnalysisAnalytical}
\alias{performLigandReceptorAnalysisAnalytical}
\title{Given a seurat object, a spatial graph, clusters and
species this function identifies ligand-receptor
interactions between neighbouring cells, identifies
ligand-receptor interactions within and between clusters
and calculates whether these are observed more frequently
than expected by chance using an analytical approach.}
\usage{
performLigandReceptorAnalysisAnalytical(
  obj,
  spatialGraph,
  species,
  clusters,
  conditional = FALSE,
  lrn = getLigandReceptorNetwork(species),
  minEdgesPos = 10
)
}
\arguments{
\item{obj}{\itemize{
\item a Seurat object
}}

\item{spatialGraph}{\itemize{
\item a data frame of neighbouring
cell pairs.
}}

\item{species}{\itemize{
\item either 'human' or 'mouse'
}}

\item{clusters}{\itemize{
\item named vector of clusters where names are each cell and
clusters are a factor
}}

\item{conditional}{\itemize{
\item if method is "analytical" and conditional is true,
p-values will be calculated given the proportion of cells that express
ligands and receptors in the specific clusters. Otherwise global proportions
of ligand and receptor expression are used. Defaults to FALSE.
}}

\item{lrn}{\itemize{
\item a ligand-receptor network, i.e., a
data frame with columns from and to.  By default, it
retrieves the nichenetr ligand receptor network
}}

\item{minEdgesPos}{\itemize{
\item the minimum edges that need to be positive for a
ligand-receptor interaction between two clusters for a p-value to be
calculated.
}}
}
\value{
A list containing:
interactionsOnEdges - a sparse matrix where the rownames give pairs of
neighbouring cells and column names give ligand-receptor pairs.
Entries are TRUE if the ligand is expressed in the first cell and the receptor is expressed in
the second cell and FALSE if not.
interactionsOnEdgesMeta - a dataframe where the first two columns are the
cells that comprise the edges in interactionsOnEdges, and the next two
columns are their clusters.
totalInteractionsByCluster - a dataframe where the rownames are
sender-receiver cluster pairs and column names are ligand receptor pairs.
Entries are total numbers of edges on which particular ligand receptor
interactions are present.
meanInteractionsByCluster - a dataframe where the rownames are
sender-receiver cluster pairs and column names are ligand receptor pairs.
Entries are total numbers of edges on which particular ligand receptor
interactions are present (for that cluster pair) divided by the total number
of edges between those clusters.
pValues - a dataframe where the rownames are sender-receiver cluster pairs
and column names are ligand receptor pairs. Entries are uppertail p-values
describing whether a particular ligand receptor interaction is observed more
frequently between 2 clusters than expected.
totalEdges - a vector of total edges between cluster pairs.
}
\description{
Given a seurat object, a spatial graph, clusters and
species this function identifies ligand-receptor
interactions between neighbouring cells, identifies
ligand-receptor interactions within and between clusters
and calculates whether these are observed more frequently
than expected by chance using an analytical approach.
}
