% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{plotMap}
\alias{plotMap}
\alias{plotMap,SingleCellExperiment-method}
\title{Visualize expression maps}
\usage{
plotMap(
  sce,
  color_by = c("phenoName", "featureName"),
  name,
  type = c("surface.fit", "surface.se", "raw"),
  samples_only = FALSE
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object}

\item{color_by}{Indicates if nodes are colorized by a feature expression}

\item{name}{A character string specifying the featureName or phenoName}

\item{type}{Type of map; one of {"raw","surface.fit","surface.se"}}

\item{samples_only}{If only individual samples should be colorized rather
than the whole surface (default: FALSE)}
}
\value{
A \code{ggplot} object
}
\description{
Method visualizes topographical expression maps
in two dimensions.
}
\details{
Two-dimensional visualization of the trajectory. The red line
representsthe trajectory and individual points denote samples. This plot
type can either show thetopography of a given feature’s expression landscape
or colorizes individual samples by a metadata label. The feature is selected
by setting the parameter \code{color_type} and the respecitve \code{name}.
To show feature expression, a surface is fitted using isotropic (i.e., same
parameters for both map dimensions) thin-plate spline smoothing in
\code{gam}. It gives an overview of expression dynamics along all
branches of the trajectory. The parameter \code{type} defines if either the
raw/original expression data shoud be shown, the full fitted expression
surface should be shown (\code{type="surface.fit"}) or the standard error
of the surface prediction (\code{type="surface.se"}), or the expression
values of single samples only (\code{type="surface.fit"}
and \code{only_samples=TRUE}).
\cr\cr
To show all landmarks on the map, please use the parameters
\code{color_by="phenoName"} and \code{name="landmark"}.
}
\examples{
# Example data
data(exSCE)

# Plot landmarks
plotMap(exSCE, color_by="phenoName", name="landmark")

# Plot phenotype
plotMap(exSCE, color_by="phenoName", name="age")

# Plot feature expression map
plotMap(exSCE, color_by="featureName", name="feature_10", type="surface.fit")
plotMap(exSCE, color_by="featureName", name="feature_10", type="surface.fit",
        samples_only=TRUE)

#Plot surface fit standard errors
plotMap(exSCE, color_by="featureName", name="feature_10", type="surface.se")
}
\seealso{
\code{gam}
}
\author{
Daniel C. Ellwanger
}
