% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparePool.R
\name{preparePool}
\alias{preparePool}
\title{prepare data for permutation test}
\usage{
preparePool(
  TxDb,
  template,
  bindingDistribution,
  bindingType = c("TSS", "geneEnd"),
  featureType = c("transcript", "exon"),
  seqn = NA
)
}
\arguments{
\item{TxDb}{an object of \link[GenomicFeatures:TxDb-class]{TxDb}}

\item{template}{an object of \link[GenomicRanges:GRanges-class]{GRanges}}

\item{bindingDistribution}{an object of \link{bindist}}

\item{bindingType}{the relevant position to features}

\item{featureType}{feature type, transcript or exon.}

\item{seqn}{seqnames. If given, the pool for permutation will be restrict in
the given chromosomes.}
}
\value{
a list with two elements, grs, a list of
\link[GenomicRanges:GRanges-class]{GRanges}.  N, the numbers of elements
should be drawn from in each GRanges.
}
\description{
prepare data for permutation test \link{peakPermTest}
}
\examples{

    if(interactive() || Sys.getenv("USER")=="jianhongou"){
        path <- system.file("extdata", package="ChIPpeakAnno")
        peaksA <- toGRanges(file.path(path, "peaks.narrowPeak"), 
                            format="narrowPeak")
        peaksB <- toGRanges(file.path(path, "MACS2_peaks.xls"), format="MACS2")
        library(TxDb.Hsapiens.UCSC.hg19.knownGene)
        ppp <- preparePool(TxDb.Hsapiens.UCSC.hg19.knownGene, 
                           peaksA, bindingType="TSS",
                           featureType="transcript")
    }

}
\seealso{
\link{peakPermTest}, \link{bindist}
}
\author{
Jianhong Ou
}
\keyword{misc}
