% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Replicates.R
\name{computeDMRsReplicates}
\alias{computeDMRsReplicates}
\title{Compute DMRs}
\usage{
computeDMRsReplicates(
  methylationData,
  condition = NULL,
  regions = NULL,
  context = "CG",
  method = "neighbourhood",
  binSize = 100,
  test = "betareg",
  pseudocountM = 1,
  pseudocountN = 2,
  pValueThreshold = 0.01,
  minCytosinesCount = 4,
  minProportionDifference = 0.4,
  minGap = 200,
  minSize = 50,
  minReadsPerCytosine = 4,
  parallel = FALSE,
  BPPARAM = NULL,
  cores = NULL
)
}
\arguments{
\item{methylationData}{the methylation data containing all the conditions
for all the replicates.}

\item{condition}{a vector of strings indicating the conditions for each
sample in \code{methylationData}. Two different values are allowed
(for the two conditions).}

\item{regions}{a \code{\link[GenomicRanges]{GRanges}} object with the regions where to
compute the DMRs. If \code{NULL}, the DMRs are computed genome-wide.}

\item{context}{the context in which the DMRs are computed (\code{"CG"},
\code{"CHG"} or \code{"CHH"}).}

\item{method}{the method used to compute the DMRs \code{"neighbourhood"}
or \code{"bins"}). The \code{"neighbourhood"} method computates
differentially methylated cytosines. Finally, the \code{"bins"}
method partiones the genome into equal sized tilling bins and performs the
statistical test between the two conditions in each bin. For all three
methods, the cytosines or bins are then merged into DMRs without affecting
the inital parameters used when calling the differentiall methylated
cytosines/bins (p-value, difference in methylation levels, minimum number of
reads per cytosine).}

\item{binSize}{the size of the tiling bins in nucleotides. This parameter is
required only if the selected method is \code{"bins"}.}

\item{test}{the statistical test used to call DMRs (\code{"betareg"} for
Beta regression).}

\item{pseudocountM}{numerical value to be added to the methylated reads
before modelling beta regression.}

\item{pseudocountN}{numerical value to be added to the total reads
before modelling beta regression.}

\item{pValueThreshold}{DMRs with p-values (when performing the statistical
test; see \code{test}) higher or equal than \code{pValueThreshold} are
discarded. Note that we adjust the p-values using the Benjamini and
Hochberg's method to control the false discovery rate.}

\item{minCytosinesCount}{DMRs with less cytosines in the specified context
than \code{minCytosinesCount} will be discarded.}

\item{minProportionDifference}{DMRs where the difference in methylation
proportion between the two conditions is lower than
\code{minProportionDifference} are discarded.}

\item{minGap}{DMRs separated by a gap of at least \code{minGap} are not
merged. Note that only DMRs where the change in methylation is in the same
direction are joined.}

\item{minSize}{DMRs with a size smaller than \code{minSize} are discarded.}

\item{minReadsPerCytosine}{DMRs with the average number of reads lower than
\code{minReadsPerCytosine} are discarded.}

\item{parallel}{Logical; run in parallel if \code{TRUE}.}

\item{BPPARAM}{A \code{BiocParallelParam} object controlling parallel execution.
This value will automatically set when parallel is \code{TRUE}, also able to set as manually.}

\item{cores}{Integer number of workers (must not exceed BPPARAM$workers).
This value will automatically set as the maximum number of system workers,
also able to set as manually.}
}
\value{
the DMRs stored as a \code{\link[GenomicRanges]{GRanges}} object with the following
metadata columns:
\describe{
 \item{direction}{a number indicating whether the region lost (-1)  or gain
 (+1) methylation in condition 2 compared to condition 1.}
 \item{context}{the context in which the DMRs was computed (\code{"CG"},
 \code{"CHG"} or \code{"CHH"}).}
 \item{sumReadsM1}{the number of methylated reads in condition 1.}
 \item{sumReadsN1}{the total number of reads in condition 1.}
 \item{proportion1}{the proportion methylated reads in condition 1.}
 \item{sumReadsM2}{the number of methylated reads in condition 2.}
 \item{sumReadsN2}{the total number reads in condition 2.}
 \item{proportion2}{the proportion methylated reads in condition 2.}
 \item{cytosinesCount}{the number of cytosines in the DMR.}
 \item{regionType}{a string indicating whether the region lost (\code{"loss"})
 or gained (\code{"gain"}) methylation in condition 2 compared to condition 1.}
 \item{pValue}{the p-value (adjusted to control the false discovery rate with
 the Benjamini and Hochberg's method) of the statistical test when the DMR was
 called.}
}
}
\description{
This function computes the differentially methylated regions between
replicates with two conditions.
}
\examples{

\dontrun{
# starting with data joined using joinReplicates
data("syntheticDataReplicates")

# compute the DMRs in CG context with neighbourhood method

# creating condition vector
condition <- c("a", "a", "b", "b")

# computing DMRs using the neighbourhood method
DMRsReplicatesNeighbourhood <- computeDMRsReplicates(methylationData = syntheticDataReplicates,
                                                     condition = condition,
                                                     regions = NULL,
                                                     context = "CHH",
                                                     method = "neighbourhood",
                                                     test = "betareg",
                                                     pseudocountM = 1,
                                                     pseudocountN = 2,
                                                     pValueThreshold = 0.01,
                                                     minCytosinesCount = 4,
                                                     minProportionDifference = 0.4,
                                                     minGap = 200,
                                                     minSize = 50,
                                                     minReadsPerCytosine = 4,
                                                     cores = 1)
}
}
\author{
Alessandro Pio Greco and Nicolae Radu Zabet
}
