% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{computeMethylationProfile}
\alias{computeMethylationProfile}
\title{Compute methylation profile}
\usage{
computeMethylationProfile(
  methylationData,
  region,
  windowSize = floor(width(region)/500),
  context = "CG"
)
}
\arguments{
\item{methylationData}{the methylation data stored as a \code{\link{GRanges}}
object with four metadata columns (see \code{\link{methylationDataList}}).}

\item{region}{a \code{\link{GRanges}} object with the regions where to
compute the DMRs.}

\item{windowSize}{a \code{numeric} value indicating the size of the window in
which methylation is averaged.}

\item{context}{the context in which the DMRs are computed (\code{"CG"},
\code{"CHG"} or \code{"CHH"}).}
}
\value{
a \code{\link{GRanges}} object with equal sized tiles of the
\code{region}. The object consists of the following metadata
\describe{
 \item{sumReadsM}{the number of methylated reads.}
 \item{sumReadsN}{the total number of reads.}
 \item{Proportion}{the proportion of methylated reads.}
 \item{cytosinesCount}{the number of cytosines in the regions}
 \item{context}{the context (\code{"CG"}, \code{"CHG"} or \code{"CHH"}).}
}
}
\description{
This function computes the low resolution profiles for the bisulfite
sequencing data.
}
\examples{

# load the methylation data
data(methylationDataList)

# the region where to compute the profile
region <- GRanges(seqnames = Rle("Chr3"), ranges = IRanges(1,1E6))

# compute low resolution profile in 20 Kb windows
lowResProfileWTCHH <- computeMethylationProfile(methylationDataList[["WT"]],
                     region, windowSize = 20000, context = "CHH")

\dontrun{
# compute low resolution profile in 10 Kb windows
lowResProfileWTCG <- computeMethylationProfile(methylationDataList[["WT"]],
                     region, windowSize = 10000, context = "CG")

lowResProfileMet13CG <- computeMethylationProfile(
                     methylationDataList[["met1-3"]],  region,
                     windowSize = 10000, context = "CG")
}

}
\seealso{
\code{\link{plotMethylationProfileFromData}},
\code{\link{plotMethylationProfile}}, \code{\link{methylationDataList}}
}
\author{
Nicolae Radu Zabet and Jonathan Michael Foonlan Tsang
}
