% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{computeOverlapProfile}
\alias{computeOverlapProfile}
\title{Compute Overlaps Profile}
\usage{
computeOverlapProfile(
  subRegions,
  largeRegion,
  windowSize = floor(width(largeRegion)/500),
  binary = TRUE,
  cores = 1
)
}
\arguments{
\item{subRegions}{a \code{\link{GRanges}} object with the sub regions; e.g.
can be the DMRs.}

\item{largeRegion}{a \code{\link{GRanges}} object with the region where to
compute the overlaps; e.g. a chromosome}

\item{windowSize}{The \code{largeRegion} is partitioned into equal sized
tiles of width \code{windowSize}.}

\item{binary}{a value indicating whether to count 1 for each overlap or to
compute the width of the overlap}

\item{cores}{the number of cores used to compute the DMRs.}
}
\value{
a \code{\link{GRanges}} object with equal sized tiles of the regions.
The object has one metadata file \code{score} which represents: the number of
subRegions overlapping with the tile, in the case of \code{binary = TRUE},
and the width of the subRegions overlapping with the tile , in the case of
\code{binary = FALSE}.
}
\description{
This function computes the distribution of a subset of regions
(\code{\link{GRanges}} object)  over a large region (\code{\link{GRanges}}
object)
}
\examples{
# load the methylation data
data(methylationDataList)

# load the DMRs in CG context
data(DMRsNoiseFilterCG)

# the coordinates of the area to be plotted
largeRegion <- GRanges(seqnames = Rle("Chr3"), ranges = IRanges(1,1E5))

# compute overlaps distribution
hotspots <- computeOverlapProfile(DMRsNoiseFilterCG, largeRegion,
           windowSize = 10000, binary = FALSE)
}
\seealso{
\code{\link{plotOverlapProfile}}, \code{\link{filterDMRs}},
\code{\link{computeDMRs}} and \code{\link{mergeDMRsIteratively}}
}
\author{
Nicolae Radu Zabet
}
