% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conclusion.R
\name{conclusion}
\alias{conclusion}
\title{Compute Summary Statistics for Spiked Species}
\usage{
conclusion(
  obj,
  merged_spiked_species,
  max_passed_range = 11,
  output_path = "merged_data.docx"
)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object containing microbiome data.}

\item{merged_spiked_species}{A character vector of spiked species names.}

\item{max_passed_range}{Numeric, maximum threshold for passing spike percentage.}

\item{output_path}{Character, file path for the \code{.docx} output from \code{calculate_spike_percentage()}.}
}
\value{
A list containing:
\item{summary_stats}{A \code{flextable} summary of the spike statistics.}
\item{full_report}{The full spiked species report as a \code{data.frame}.}
\item{phy_tree}{The phylogenetic tree (if available).}
}
\description{
Computes per-sample spike-in summary statistics from a microbiome object (\code{phyloseq} or \code{TSE}),
generates a spike-in success report using \code{calculate_spike_percentage()}, and returns both the raw data and
a formatted summary table (\code{flextable}). The function also attempts to extract and retain the phylogenetic tree if present.
}
\examples{
## -------------------------------
## Example 1: Using phyloseq object
## -------------------------------
library(DspikeIn)
data("physeq_16SOTU", package = "DspikeIn")

# Merge spike-in species
species_name <- c("Tetragenococcus_halophilus", "Tetragenococcus_sp.")
merged_sum <- Pre_processing_species(
  obj = physeq_16SOTU,
  species_name = species_name,
  merge_method = "sum"
)

# Compute summary statistics
output_doc <- file.path(tempdir(), "summary_phyloseq.docx")

results_physeq <- conclusion(
  obj = merged_sum,
  merged_spiked_species = "Tetragenococcus_halophilus",
  max_passed_range = 20,
  output_path = output_doc
)
print(results_physeq$summary_stats)

## -----------------------------------------------
## Example 2: Using TreeSummarizedExperiment object
## -----------------------------------------------
tse_16SOTU <- convert_phyloseq_to_tse(physeq_16SOTU)

output_doc_tse <- file.path(tempdir(), "summary_tse.docx")
results_tse <- conclusion(
  obj = tse_16SOTU,
  merged_spiked_species = "Tetragenococcus_halophilus",
  max_passed_range = 20,
  output_path = output_doc_tse
)
print(results_tse$summary_stats)

}
