% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_count_phyloseq.R
\name{summ_count_phyloseq}
\alias{summ_count_phyloseq}
\title{Summary Statistics of a Phyloseq or TSE Object}
\usage{
summ_count_phyloseq(obj)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object containing taxonomic and abundance data.}
}
\value{
A data frame with overall summary statistics.
}
\description{
Computes overall summary statistics (mean, median, standard deviation, standard error, and quantiles)
for the OTU table in a \code{phyloseq} or \code{TreeSummarizedExperiment} (TSE) object.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")

  # Summarize counts for the phyloseq object
  summary_stats_physeq <- summ_count_phyloseq(physeq_16SOTU)

  # Convert phyloseq object to a TreeSummarizedExperiment (TSE)
  tse_16SOTU <- convert_phyloseq_to_tse(physeq_16SOTU)

  # Summarize counts for the TSE object
  summary_stats_tse <- summ_count_phyloseq(tse_16SOTU)
}

}
