% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DuplexDiscovererResults.R
\docType{class}
\name{DuplexDiscovererResults-class}
\alias{DuplexDiscovererResults-class}
\alias{DuplexDiscovererResults}
\title{DuplexDiscovererResults}
\usage{
DuplexDiscovererResults(
  duplex_groups,
  chimeric_reads,
  reads_classes,
  chimeric_reads_stats,
  run_stats
)
}
\arguments{
\item{duplex_groups}{\pkg{GInteractions} object with duplex groups}

\item{chimeric_reads}{\pkg{GInteractions} object with chimeric reads}

\item{reads_classes}{\code{tibble} (tbl_df) with read classification data.}

\item{chimeric_reads_stats}{\code{tibble} (tbl_df)  read type statistics.}

\item{run_stats}{\code{tibble} (tbl_df)  runtime and memory info}
}
\value{
A \code{DuplexDiscovererResults} object.
}
\description{
A helper S4 class to store the results of the full
DuplexDiscovereR analysis.
This class contains the following output:
\itemize{
\item \code{duplex_groups}:  clustered duplex groups.
\item \code{chimeric_reads}: individual two-regions chimeric reads.
Contains both clustered and unclustered reads.
Clustered reads are linked to the duplex groups though 'dg_id' field in metadata
\item \code{reads_classes}: dataframe parallel to the the input containing classification result and detected mapping type for each entry in the input
\item \code{chimeric_reads_stats}: dataframe containing read type classification statistics
\item \code{run_stats}: data frame containing statistics about the time and memory used by the pipeline
}
}
\details{
Each output type has a corresponding accessor:
\itemize{
\item \code{\link[=dd_get_duplex_groups]{dd_get_duplex_groups()}}
\item \code{\link[=dd_get_chimeric_reads]{dd_get_chimeric_reads()}}
\item \code{\link[=dd_get_reads_classes]{dd_get_reads_classes()}}
\item \code{\link[=dd_get_chimeric_reads_stats]{dd_get_chimeric_reads_stats()}}
\item \code{\link[=dd_get_run_stats]{dd_get_run_stats()}}
}
}
\section{Slots}{

\describe{
\item{\code{duplex_groups}}{\pkg{GInteractions} object with duplex groups}

\item{\code{chimeric_reads}}{\pkg{GInteractions} object with chimeric reads}

\item{\code{reads_classes}}{\code{tibble} (tbl_df) with read classification data.}

\item{\code{chimeric_reads_stats}}{\code{tibble} (tbl_df)  read type statistics.}

\item{\code{run_stats}}{\code{tibble} (tbl_df)  runtime and memory info}
}}

\examples{

# load example input
data("RNADuplexesSmallGI")
data("RNADuplexesSampleData")
# run whole pipeline
result <- runDuplexDiscoverer(
    data = SampleSmallGI,
    junctions_gr = SampleSpliceJncGR,
    anno_gr = SampleGeneAnnoGR,
    sample_name = "run_example",
    lib_type = "SE",
    table_type = "STAR"
)
# access results
show(result)
gi_clusters <- dd_get_duplex_groups(result)
gi_reads <- dd_get_chimeric_reads(result)
df_reads <- dd_get_reads_classes(result)
dd_get_reads_classes(result)
dd_get_run_stats(result)
}
\seealso{
\code{\link[=dd_get_duplex_groups]{dd_get_duplex_groups()}} ,
\code{\link[=dd_get_chimeric_reads]{dd_get_chimeric_reads()}} ,
\code{\link[=dd_get_reads_classes]{dd_get_reads_classes()}} ,
\code{\link[=dd_get_chimeric_reads_stats]{dd_get_chimeric_reads_stats()}} ,
\code{\link[=dd_get_run_stats]{dd_get_run_stats()}}
}
