% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_percent_hits.R
\name{check_percent_hits}
\alias{check_percent_hits}
\title{Get percentage of target cell type hits}
\usage{
check_percent_hits(
  full_results,
  target_celltype,
  mtc_method = "bonferroni",
  q_threshold = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{full_results}{\code{bootstrap_enrichment_test} results.}

\item{target_celltype}{Substring to search to matching
cell types (case-insensitive).}

\item{mtc_method}{Multiple-testing correction method.}

\item{q_threshold}{Corrected significance threshold.}

\item{verbose}{Print messages.}
}
\value{
Report list.
}
\description{
After you run \link[EWCE]{bootstrap_enrichment_test},
 check what percentage of significantly enriched
 cell types match an expected cell type.
}
\examples{
## Bootstrap significance test,
##  no control for transcript length or GC content
## Use pre-computed results to speed up example
full_results <- EWCE::example_bootstrap_results()

report <- EWCE::check_percent_hits(
    full_results = full_results,
    target_celltype = "microglia"
)
}
