% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_transcriptome_results.R
\name{example_transcriptome_results}
\alias{example_transcriptome_results}
\title{Example bootstrap celltype enrichment test for transcriptome data}
\source{
## Load the single cell data

ctd <- ewceData::ctd()

## Set the parameters for the analysis

## Use 3 bootstrap lists for speed, for publishable analysis use >10,000

reps <- 3

annotLevel <- 1 # <- Use cell level annotations (i.e. Interneurons)

## Use 5 up/down regulated genes (thresh) for speed, default is 250

thresh <- 5

## Load the top table

tt_alzh <- ewceData::tt_alzh()

tt_results <- EWCE::ewce_expression_data(
    sct_data = ctd,
    tt = tt_alzh,
    annotLevel = 1,
    thresh = thresh,
    reps = reps,
    ttSpecies = "human",
    sctSpecies = "mouse"
)

save(tt_results, file = "inst/extdata/tt_results.rda")
}
\usage{
example_transcriptome_results(verbose = TRUE, localHub = FALSE)
}
\arguments{
\item{verbose}{Print messages.}

\item{localHub}{If working offline, add argument localHub=TRUE to work 
with a local, non-updated hub; It will only have resources available that
have previously been downloaded. If offline, Please also see BiocManager
vignette section on offline use to ensure proper functionality.}
}
\value{
List with 5 items.
}
\description{
Example celltype enrichment
results produced by \link[EWCE]{ewce_expression_data}.
}
\examples{
tt_results <- EWCE::example_transcriptome_results()
}
