% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_bad_hgnc_symbols.r
\name{fix_bad_hgnc_symbols}
\alias{fix_bad_hgnc_symbols}
\title{fix_bad_hgnc_symbols}
\usage{
fix_bad_hgnc_symbols(
  exp,
  dropNonHGNC = FALSE,
  as_sparse = TRUE,
  verbose = TRUE,
  localHub = FALSE
)
}
\arguments{
\item{exp}{An expression matrix where the rows are HGNC symbols or a
SingleCellExperiment (SCE) or other
 Ranged Summarized Experiment (SE) type object.}

\item{dropNonHGNC}{Boolean. Should symbols not recognised as HGNC symbols
be dropped?}

\item{as_sparse}{Convert \code{exp} to sparse matrix.}

\item{verbose}{Print messages.}

\item{localHub}{If working offline, add argument localHub=TRUE to work 
with a local, non-updated hub; It will only have resources available that
have previously been downloaded. If offline, Please also see BiocManager
vignette section on offline use to ensure proper functionality.}
}
\value{
Returns the expression matrix with the rownames corrected and rows
representing the same gene merged. If a SingleCellExperiment (SCE) or other
Ranged Summarized Experiment (SE) type object was inputted this will be
returned with the corrected expression matrix under counts.
}
\description{
Given an expression matrix, wherein the rows are supposed to be HGNC
symbols, find those symbols which are not official HGNC symbols, then
correct them if possible. Return the expression matrix with corrected
symbols.
}
\examples{
# create example expression matrix, could be part of a exp, annot list obj
exp <- matrix(data = runif(70), ncol = 10)
# Add HGNC gene names but add with an error:
# MARCH8 is a HGNC symbol which if opened in excel will convert to Mar-08
rownames(exp) <-
    c("MT-TF", "MT-RNR1", "MT-TV", "MT-RNR2", "MT-TL1", "MT-ND1", "Mar-08")
exp <- fix_bad_hgnc_symbols(exp)
# fix_bad_hgnc_symbols warns the user of this possible issue
}
