% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-methods.R
\name{new_with_repaired_slots}
\alias{new_with_repaired_slots}
\title{Instantiate a class, but warn rather than error for badly named slots}
\usage{
new_with_repaired_slots(classname, ..., extra)
}
\arguments{
\item{classname}{`character` naming a class}

\item{...}{slots in `classname`}

\item{extra}{named list giving other slots in `classname`}
}
\value{
`new(classname)`
}
\description{
Instantiate a class, but warn rather than error for badly named slots
}
\examples{
MAST:::new_with_repaired_slots("SimpleList",  listData = list(x = LETTERS), 
extra = list(elementType = 'character', food = "tasty", beer = "cold"))
}
