% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareData.R
\name{convertGroupToNumericDose}
\alias{convertGroupToNumericDose}
\title{Convert MSstats GROUP labels to numeric dose in nM and extract drug name}
\usage{
convertGroupToNumericDose(group_vector)
}
\arguments{
\item{group_vector}{A character or factor vector with GROUP labels (e.g., "Dasatinib_003uM")}
}
\value{
A data frame with two columns: dose_nM (numeric), and drug (character).
}
\description{
Convert MSstats GROUP labels to numeric dose in nM and extract drug name
}
\examples{
# Example 1: Basic conversion with mixed units
groups <- c("DMSO", "Dasatinib_001uM", "Dasatinib_010uM",
            "Dasatinib_100nM", "Dasatinib_1000nM")
dose_info <- convertGroupToNumericDose(groups)
print(dose_info)

# Example 2: Handle multiple drugs
multi_drug_groups <- c("DMSO",
                      "Dasatinib_001uM", "Dasatinib_010uM",
                      "Imatinib_001uM", "Imatinib_010uM")
multi_dose_info <- convertGroupToNumericDose(multi_drug_groups)
print(multi_dose_info)

# Show unique drugs found
print(unique(multi_dose_info$drug))

}
