% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualize_Isotonic_Fit.R
\name{visualizeResponseProtein}
\alias{visualizeResponseProtein}
\title{Plot isotonic regression fit with optional IC50 for a single protein and drug}
\usage{
visualizeResponseProtein(
  data,
  protein_name,
  drug_name,
  ratio_response = TRUE,
  transform_dose = TRUE,
  show_ic50 = TRUE,
  add_ci = FALSE,
  n_samples = 1000,
  alpha = 0.1,
  increasing = FALSE,
  y_lab = "Ratio Response"
)
}
\arguments{
\item{data}{Protein-level dataset (e.g., output of MSstatsPrepareDoseResponseFit).}

\item{protein_name}{Character. Protein name to plot.}

\item{drug_name}{Character. Drug name to plot.}

\item{ratio_response}{Logical. If TRUE, compute IC50 on ratio scale; if FALSE, use log2 intensities.}

\item{transform_dose}{Logical. If TRUE, applies log10(dose + 1). Default is TRUE.}

\item{show_ic50}{Logical. If TRUE, adds vertical line and annotation for IC50.}

\item{add_ci}{Logical. Include IC50 95\% confidence interval bands if TRUE. Default is FALSE.}

\item{n_samples}{Number of bootstrap samples if including confidence intervals. Default is 1000.}

\item{alpha}{Alpha level for confidence intervals. Default is 0.05.}

\item{increasing}{Logical. If TRUE, fits a non-decreasing model. If FALSE, fits non-increasing.}

\item{y_lab}{Character. Label for the y-axis. Default is "Ratio Response".}
}
\value{
A ggplot object.
}
\description{
Plot isotonic regression fit with optional IC50 for a single protein and drug
}
\examples{
# Load example data
data_path <- system.file("extdata", "DIA_MSstats_Normalized.RDS",
                         package = "MSstatsResponse")
dia_data <- readRDS(data_path)

# Convert GROUP to dose
dose_info <- convertGroupToNumericDose(dia_data$ProteinLevelData$GROUP)
dia_data$ProteinLevelData$dose <- dose_info$dose_nM * 1e-9
dia_data$ProteinLevelData$drug <- dose_info$drug

# Prepare data for analysis
prepared_data <- MSstatsPrepareDoseResponseFit(
  dia_data$ProteinLevelData,
  dose_column = "dose",
  drug_column = "drug",
  protein_column = "Protein",
  log_abundance_column = "LogIntensities"
)

# Example 1: Basic dose-response visualization
plot1 <- visualizeResponseProtein(
  data = prepared_data,
  protein_name = "PROTEIN_A",
  drug_name = "Drug1",
  ratio_response = TRUE,
  show_ic50 = FALSE,
  add_ci = FALSE
)
print(plot1)

# Example 2: Add IC50 annotation
plot2 <- visualizeResponseProtein(
  data = prepared_data,
  protein_name = "PROTEIN_A",
  drug_name = "Drug1",
  ratio_response = TRUE,
  show_ic50 = TRUE,
  add_ci = FALSE
)
print(plot2)

}
