% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSEApreprocessing.R
\name{GSEApreprocessing}
\alias{GSEApreprocessing}
\title{GSEA preprocessing for official software and online tools.}
\usage{
GSEApreprocessing(
  SEresDE,
  ColumnsCriteria,
  Set.Operation,
  Rnk.files = TRUE,
  Save.files = FALSE
)
}
\arguments{
\item{SEresDE}{A SummarizedExperiment class object. Output from
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}
(see \code{Examples}).}

\item{ColumnsCriteria}{A vector of integers where each integer indicates
a column of  \code{SummarizedExperiment::rowData(SEresDE)}.
These columns should either contain only binary values, or may contain other
numerical value, in which case extracted outputs from \code{SEresDE}
will be those with >0 values (see \code{Details}).}

\item{Set.Operation}{A character. The user must choose between "union"
(default), "intersect", "setdiff" (see \code{Details}).}

\item{Rnk.files}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
If \code{TRUE}, the rnk files generated by the function (used by the GSEA
software) will be saved if \code{Save.files=TRUE} and \code{path.result} of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}
is not NULL. Otherwise the rnk files will not be generated.}

\item{Save.files}{\code{TRUE} or \code{FALSE} or a Character.
If \code{Save.files=TRUE} and the \code{path.result} of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}
is not NULL, all files will be saved in
"2_SupervisedAnalysis_\code{Name.folder.DE}/
2-5_Enrichment_analysis_\code{Name.folder.DE}/
2-5-2_EnrichmentGO_software_preprocessing".
If \code{Save.files} is a character, it must be a path and all files
will be saved in the sub-folder "EnrichmentGO_software_preprocessing".
Otherwise, the different files will not be saved.}
}
\value{
The function returns
\itemize{
\item A vector of character containing gene names specified by
\code{ColumnsCriteria} and \code{Set.Operation}.
\item A vector of character containing all gene names
\item And, in case where \code{Save.files=TRUE} and the \code{path.result} of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}
is not NULL, specific files designed to be used
as input for the following online tools and software :
\itemize{
\item GSEA : \url{https://www.gsea-msigdb.org/gsea/index.jsp}
\item DAVID : \url{https://david.ncifcrf.gov/tools.jsp}
\item WebGestalt : \url{http://www.webgestalt.org}
\item gProfiler : \url{https://biit.cs.ut.ee/gprofiler/gost}
\item Panther : \url{http://www.pantherdb.org}
\item ShinyGO : \url{http://bioinformatics.sdstate.edu/go/}
\item Enrichr : \url{https://maayanlab.cloud/Enrichr/}
\item GOrilla : \url{http://cbl-gorilla.cs.technion.ac.il}.
}
}
}
\description{
The function returns, from the output of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}},
specific files designed to be used as input for several online online tools
and software given in the section \code{Value}.
}
\details{
We have the following three cases:
\itemize{
\item If \code{Set.Operation="union"} then the rows extracted from
the different datasets (raw counts, normalized data and
\code{SummarizedExperiment::rowData(SEresDE)})
included in the SummarizedExperiment class object \code{SEresDE}
are those such that the sum of the selected columns of
\code{SummarizedExperiment::rowData(SEresDE)}
given in \code{ColumnsCriteria} is >0.
This means that the selected genes are those having at least one ’1’
in one of the selected columns.
\item If \code{Set.Operation="intersect"} then the rows extracted from
the different datasets (raw counts, normalized data and
\code{SummarizedExperiment::rowData(SEresDE)})
included in the SummarizedExperiment class object \code{SEresDE}
are those such that the product of the selected columns of
\code{SummarizedExperiment::rowData(SEresDE)}
given in \code{ColumnsCriteria} is >0.
This means that the selected genes are those having ’1’
in all of the selected columns.
\item If \code{Set.Operation="setdiff"} then the rows extracted from
the different datasets (raw counts, normalized data and
\code{SummarizedExperiment::rowData(SEresDE)})
included in the SummarizedExperiment class object \code{SEresDE}
are those such that only one element of the selected columns of
\code{SummarizedExperiment::rowData(SEresDE)}
given in \code{ColumnsCriteria} is >0.
This means that the selected genes are those having ’1’
in only one of the selected columns.
}
}
\examples{
data(RawCounts_Antoszewski2022_MOUSEsub500)
## No time points. We take only two groups for the speed of the example
RawCounts_T1Wt <- RawCounts_Antoszewski2022_MOUSEsub500[, seq_len(7)]
##------------------------------------------------------------------------##
## Preprocessing
resDATAprepSE <- DATAprepSE(RawCounts=RawCounts_T1Wt,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=NULL,
                            Individual.position=2)
##------------------------------------------------------------------------##
## DE analysis
resDET1wt <- DEanalysisGlobal(SEres=resDATAprepSE,
                              pval.min=0.05,
                              pval.vect.t=NULL,
                              log.FC.min=1,
                              LRT.supp.info=FALSE,
                              Plot.DE.graph=TRUE,
                              path.result=NULL,
                              Name.folder.DE=NULL)

##------------------------------------------------------------------------##
resGp <- GSEApreprocessing(SEresDE=resDET1wt,
                           ColumnsCriteria=2,
                           Set.Operation="union",
                           Rnk.files=TRUE,
                           Save.files=FALSE)
}
