% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OUTRIDER.R
\name{OUTRIDER}
\alias{OUTRIDER}
\title{OUTRIDER - Finding expression outlier events}
\usage{
OUTRIDER(
  ods,
  q,
  controlData = TRUE,
  implementation = "autoencoder",
  subsets = NULL,
  BPPARAM = bpparam(),
  ...
)
}
\arguments{
\item{ods}{An OutriderDataSet object}

\item{q}{The encoding dimensions}

\item{controlData}{If TRUE, the default, the raw counts are controled 
for confounders by the autoencoder}

\item{implementation}{"autoencoder", the default, will use the autoencoder
implementation. Also 'pca' and 'peer' can be used to control
for confounding effects}

\item{subsets}{A named list of named lists specifying any number of gene 
subsets (can differ per sample). For each subset, FDR correction
will be limited to genes in the subset, and the FDR corrected 
pvalues stored as an assay in the ods object in addition to the 
transcriptome-wide FDR corrected pvalues. See the examples for 
how to use this argument.}

\item{BPPARAM}{A 
\code{\link[BiocParallel:BiocParallelParam-class]{BiocParallelParam}}
        instance to be used for parallel computing.}

\item{...}{Further arguments passed on to \code{controlForConfounders}}
}
\value{
OutriderDataSet with all the computed values. The values are stored
            as assays and can be accessed by: \code{assay(ods, 'value')}.
            To get a full list of calculated values run:
            \code{assayNames(ods)}
}
\description{
The OUTRIDER function runs the default OUTRIDER pipeline 
combinig the fit, the computation of Z scores and P-values.
All computed values are returned as an OutriderDataSet object.

To have more control over each analysis step, one can call each 
function separately.

\enumerate{
    \item \code{\link{estimateSizeFactors}} to calculate the sizeFactors
    \item \code{\link{controlForConfounders}} to control for 
              confounding effects
    \item \code{\link{fit}} to fit the negative binomial model 
              (only needed if the autoencoder is not used)
    \item \code{\link{computePvalues}} to calculate the nominal and 
              adjusted P-values
    \item \code{\link{computeZscores}} to calculate the Z scores
}
}
\examples{
ods <- makeExampleOutriderDataSet()
implementation <- 'autoencoder'
\dontshow{
    ods <- ods[1:10,1:10]
    implementation <- 'pca'
}
ods <- OUTRIDER(ods, implementation=implementation)

pValue(ods)[1:10,1:10]
res <- results(ods, all=TRUE)
res

plotAberrantPerSample(ods)
plotVolcano(ods, 1)

# example of restricting FDR correction to subsets of genes of interest 
genesOfInterest <- list("sample_1"=sample(rownames(ods), 3), 
                         "sample_2"=sample(rownames(ods), 8), 
                         "sample_6"=sample(rownames(ods), 5))
genesOfInterest
ods <- OUTRIDER(ods, subsets=list("exampleSubset"=genesOfInterest))
padj(ods, subsetName="exampleSubset")[1:10,1:10]
res <- results(ods, all=TRUE)
res

}
