% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlForConfounders.R
\name{computeLatentSpace}
\alias{computeLatentSpace}
\title{Extracting the latent space}
\usage{
computeLatentSpace(ods)
}
\arguments{
\item{ods}{An OutriderDataSet}
}
\value{
A matrix containing the latent space determined by the autoencoder.
}
\description{
Extracts the latent space from the OutriderDataSet object 
determined by the autoencoder.
}
\examples{
ods <- makeExampleOutriderDataSet()
\dontshow{
    ods <- ods[1:10, 1:10]
}
ods <- estimateSizeFactors(ods)
ods <- controlForConfounders(ods, implementation="pca")
computeLatentSpace(ods)[,1:6]

}
