% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNSetterFunsInternal.R
\name{sampleExclusionMask}
\alias{sampleExclusionMask}
\alias{sampleExclusionMask,}
\alias{`sampleExclusionMask<-`}
\alias{sampleExclusionMask<-}
\title{Sample exclusion}
\usage{
sampleExclusionMask(ods, aeMatrix = FALSE)

sampleExclusionMask(ods) <- value
}
\arguments{
\item{ods}{An OutriderDataSet object}

\item{aeMatrix}{If \code{TRUE}, it returns a 0/1 matrix for the 
internal autoencoder functions in the form of feature x sample}

\item{value}{A logical vector of the length of the samples. If \code{TRUE},
the corresponding sample will be excluded from the autoencoder
fit.}
}
\value{
The exclusion vector/matrix.
}
\description{
To exclude a sample from the fit process, one can use this function to mask 
specific samples. This can be used if replicates are present.
}
\examples{
ods <- makeExampleOutriderDataSet()
sampleExclusionMask(ods) <- sample(c(FALSE, TRUE), ncol(ods), replace=TRUE)

sampleExclusionMask(ods)

}
