% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estPower.R
\name{Power_Cont}
\alias{Power_Cont}
\title{Run DE analysis by using MAST. Here we output two result tables corresponding to two forms of DE genes.
These parameters include four gene-wise parameters and two cell-wise parameters.}
\usage{
Power_Cont(
  DErslt,
  simData,
  alpha = 0.1,
  delta = 0.5,
  strata = c(0, 10, 2^(seq_len(4)) * 10, Inf)
)
}
\arguments{
\item{DErslt}{is from the DE analysis by MAST}

\item{simData}{is the corresponding simulated scRNA-seq dataset (SingCellExperiment)}

\item{alpha}{is the cutoff for the fdr which can be modified}

\item{delta}{or the lfc is the cutoff (=0.5) used to determined the high DE genes for Form II}

\item{strata}{can be modified by the user. By default, it is (0, 10], (10, 20], (20, 40], (40, 80], (80, Inf]}
}
\value{
a list of metrics for power analysis such as: stratified targeted power and marginal power.
}
\description{
Run DE analysis by using MAST. Here we output two result tables corresponding to two forms of DE genes.
These parameters include four gene-wise parameters and two cell-wise parameters.
}
\examples{
data("es_mef_sce")
sce = es_mef_sce[, colData(es_mef_sce)$cellTypes == "fibro"]
set.seed(123)
rix = sample(1:nrow(sce), 500)
sce = sce[rix, ]
estParas = Est2Phase(sce)
simData = Simulate2SCE(n=500, estParas1 = estParas, estParas2 = estParas)
DErslt = runDE(simData$sce)
Cont_pow = Power_Cont(DErslt, simData)
}
