% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDomainPlot.R
\name{checkOverlapDomains}
\alias{checkOverlapDomains}
\title{Identify feature type(s) containing overlapped domains/features}
\usage{
checkOverlapDomains(domainDf)
}
\arguments{
\item{domainDf}{input domain dataframe}
}
\value{
List of feature types that have overlapped domains
}
\description{
Identify feature type(s) containing overlapped domains/features
}
\examples{
# get domain data
seedID <- "101621at6656"
domainFile <- system.file(
    "extdata", "domainFiles/101621at6656.domains",
    package = "PhyloProfile", mustWork = TRUE
)
domainDf <- parseDomainInput(seedID, domainFile, "file")
# get seedDf and orthoDf
subDf <- domainDf[
    domainDf$seedID ==
    "101621at6656#101621at6656:AGRPL@224129@0:224129_0:001955:1",]
orthoDf <- subDf[subDf$orthoID == "101621at6656:DROME@7227@1:Q9VG04",]
# check overlap features
PhyloProfile:::checkOverlapDomains(orthoDf)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
