% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFastaSeqs.R
\name{getFastaFromFile}
\alias{getFastaFromFile}
\title{Get fasta sequences from main input file in multi-fasta format}
\usage{
getFastaFromFile(seqIDs = NULL, concatFasta = NULL)
}
\arguments{
\item{seqIDs}{list of sequences IDs. Set seqIDs = "all" if you want to get
all fasta sequences from the concatenated input fasta file.}

\item{concatFasta}{input concatenated fasta file.}
}
\value{
A dataframe with one column contains sequences in fasta format.
}
\description{
Get fasta sequences from main input file in multi-fasta format
}
\examples{
concatFasta <- system.file(
    "extdata", "fastaFiles/concatenatedFile.fa",
    package = "PhyloProfile", mustWork = TRUE
)
getFastaFromFasInput("all", concatFasta)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
