% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QFeatures-filter.R
\docType{class}
\name{QFeatures-filtering}
\alias{QFeatures-filtering}
\alias{filterFeatures}
\alias{filterFeatures,QFeatures,formula-method}
\alias{filterFeatures,QFeatures,AnnotationFilter-method}
\alias{CharacterVariableFilter}
\alias{NumericVariableFilter}
\alias{VariableFilter}
\alias{isDuplicated}
\alias{CharacterVariableFilter-class}
\alias{NumericVariableFilter-class}
\title{Filter features based on their rowData}
\usage{
VariableFilter(field, value, condition = "==", not = FALSE)

\S4method{filterFeatures}{QFeatures,AnnotationFilter}(object, filter, i, na.rm = FALSE, keep = FALSE, ...)

\S4method{filterFeatures}{QFeatures,formula}(object, filter, i, na.rm = FALSE, keep = FALSE, ...)

isDuplicated(x)
}
\arguments{
\item{field}{\code{character(1)} refering to the name of the variable
to apply the filter on.}

\item{value}{\code{character()} or \code{integer()} value for the
\code{CharacterVariableFilter} and \code{NumericVariableFilter} filters
respectively.}

\item{condition}{\code{character(1)} defining the condition to be used in
the filter. For \code{NumericVariableFilter}, one of \code{"=="},
\code{"!="}, \code{">"}, \code{"<"}, \code{">="} or \code{"<="}. For
\code{CharacterVariableFilter}, one of \code{"=="}, \code{"!="},
\code{"startsWith"}, \code{"endsWith"} or \code{"contains"}. Default
condition is \code{"=="}.}

\item{not}{\code{logical(1)} indicating whether the filtering should be negated
or not. \code{TRUE} indicates is negated (!). \code{FALSE} indicates not negated.
Default \code{not} is \code{FALSE}, so no negation.}

\item{object}{An instance of class \link{QFeatures}.}

\item{filter}{Either an instance of class \link{AnnotationFilter} or a
formula.}

\item{i}{A numeric, logical or character vector pointing to the
assay(s) to be filtered.}

\item{na.rm}{\code{logical(1)} indicating whether missing values should
be removed. Default is \code{FALSE}.}

\item{keep}{\code{logical(1)} indicating whether to keep the features
of assays for which at least one of the filtering variables are
missing in the rowData. When \code{FALSE} (default), all such assay
will contain 0 features; when \code{TRUE}, the assays are untouched.}

\item{...}{Additional parameters. Currently ignored.}

\item{x}{A \code{vector()} that will be checked for duplications.}
}
\value{
An filtered \code{QFeature} object.
}
\description{
The \code{filterFeatures} methods enables users to filter features
based on a variable in their \code{rowData}. The features matching the
filter will be returned as a new object of class \code{QFeatures}. The
filters can be provided as instances of class \code{AnnotationFilter}
(see below) or as formulas.
}
\section{The filtering procedure}{


\code{filterFeatures()} will go through each assay of the \code{QFeatures}
object and apply the filtering on the corresponding \code{rowData}.
Features that do not pass the filter condition are removed from
the assay. In some cases, one may want to filter for a variable
present in some assay, but not in other. There are two options:
either provide \code{keep = FALSE} to remove all features for those
assays (and thus leaving an empty assay), or provide \code{keep = TRUE}
to ignore filtering for those assays.

Because features in a \code{QFeatures} object are linked between different
assays with \code{AssayLinks}, the links are automatically updated.
However, note that the function doesn't propagate the filter to parent
assays. For example, suppose a peptide assay with 4 peptides is
linked to a protein assay with 2 proteins (2 peptides mapped per
protein) and you apply \code{filterFeatures()}. All features pass the
filter except for one protein. The peptides mapped to that protein
will remain in the \code{QFeatures} object. If propagation of the
filtering rules to parent assay is desired, you may want to use
\code{x[i, , ]} instead (see the \emph{Subsetting} section in \code{?QFeature}).
}

\section{Variable filters}{


The variable filters are filters as defined in the
\link{AnnotationFilter} package. In addition to the pre-defined filter,
users can arbitrarily set a field on which to operate. These
arbitrary filters operate either on a character variables (as
\code{CharacterVariableFilter} objects) or numerics (as
\code{NumericVariableFilters} objects), which can be created with the
\code{VariableFilter} constructor.
}

\section{Helper functions}{

\itemize{
\item The \code{isDuplicated()} function takes a vector (or rowData variable when
used to filter features) as input, and return a logical of the same
length, with elements set to \code{TRUE} for unique occurence, and \code{FALSE}
otherwise. This function is different from \code{\link[=duplicated]{duplicated()}}, as here even
the first occurence is set to \code{FALSE}. See \code{\link[=createPrecursorId]{createPrecursorId()}} for an
application.
}
}

\examples{

## ----------------------------------------
## Creating character and numberic
## variable filters
## ----------------------------------------

VariableFilter(field = "my_var",
               value = "value_to_keep",
               condition = "==")

VariableFilter(field = "my_num_var",
               value = 0.05,
               condition = "<=")

example(aggregateFeatures)

## ----------------------------------------------------------------
## Filter all features that are associated to the Mitochondrion in
## the location feature variable. This variable is present in all
## assays.
## ----------------------------------------------------------------

## using the forumla interface, exact mathc
filterFeatures(feat1, ~  location == "Mitochondrion")

## using the forumula intefrace, martial match
filterFeatures(feat1, ~startsWith(location, "Mito"))

## using a user-defined character filter
filterFeatures(feat1, VariableFilter("location", "Mitochondrion"))

## using a user-defined character filter with partial match
filterFeatures(feat1, VariableFilter("location", "Mito", "startsWith"))
filterFeatures(feat1, VariableFilter("location", "itochon", "contains"))

## ----------------------------------------------------------------
## Filter all features that aren't marked as unknown (sub-cellular
## location) in the feature variable
## ----------------------------------------------------------------

## using a user-defined character filter
filterFeatures(feat1, VariableFilter("location", "unknown", condition = "!="))

## using the forumula interface
filterFeatures(feat1, ~ location != "unknown")

## ----------------------------------------------------------------
## Filter features that have a p-values lower or equal to 0.03
## ----------------------------------------------------------------

## using a user-defined numeric filter
filterFeatures(feat1, VariableFilter("pval", 0.03, "<="))

## using the formula interface
filterFeatures(feat1, ~ pval <= 0.03)

## you can also remove all p-values that are NA (if any)
filterFeatures(feat1, ~ !is.na(pval))

## ----------------------------------------------------------------
## Negative control - filtering for an non-existing markers value,
## returning empty results.
## ----------------------------------------------------------------

filterFeatures(feat1, VariableFilter("location", "not"))

filterFeatures(feat1, ~ location == "not")

## ----------------------------------------------------------------
## Filtering for a  missing feature variable. The outcome is controled
## by keep
## ----------------------------------------------------------------
data(feat2)

filterFeatures(feat2, ~ y < 0)

filterFeatures(feat2, ~ y < 0, keep = TRUE)

## ----------------------------------------------------------------
## Example with missing values
## ----------------------------------------------------------------

data(feat1)
rowData(feat1[[1]])[1, "location"] <- NA
rowData(feat1[[1]])

## The row with the NA is not removed
rowData(filterFeatures(feat1, ~ location == "Mitochondrion")[[1]])
rowData(filterFeatures(feat1, ~ location == "Mitochondrion", na.rm = FALSE)[[1]])

## The row with the NA is removed
rowData(filterFeatures(feat1, ~ location == "Mitochondrion", na.rm = TRUE)[[1]])

## Note that in situations with missing values, it is possible to
## use the `\%in\%` operator or filter missing values out
## explicitly.

rowData(filterFeatures(feat1, ~ location \%in\% "Mitochondrion")[[1]])
rowData(filterFeatures(feat1, ~ location \%in\% c(NA, "Mitochondrion"))[[1]])

## Explicit handling
filterFeatures(feat1, ~ !is.na(location) & location == "Mitochondrion")

## Using the pipe operator
feat1 |>
   filterFeatures( ~ !is.na(location)) |>
   filterFeatures( ~ location == "Mitochondrion")
}
\seealso{
The \link{QFeatures} man page for subsetting and the \code{QFeatures}
vignette provides an extended example.
}
\author{
Laurent Gatto
}
