% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process1KG_internal.R
\encoding{UTF-8}
\name{generateGeneBlock}
\alias{generateGeneBlock}
\title{Generate two indexes based on gene annotation for gdsAnnot1KG block}
\usage{
generateGeneBlock(gdsReference, winSize = 10000, ensDb)
}
\arguments{
\item{gdsReference}{an object of class
\link[gdsfmt]{gds.class} (a GDS file), the opened 1KG GDS file (reference).}

\item{winSize}{a single positive \code{integer} representing the
size of the window to use to group the SNVs when the SNVs are in a
non-coding region. Default: \code{10000}.}

\item{ensDb}{An object of class \code{EnsDb} with the Ensembl genome
annotation. By default, the \code{EnsDb.Hsapiens.v86} class has been used.}
}
\value{
a \code{data.frame} with those columns:
\describe{
\item{chr}{ a single \code{integer} representing the SNV chromosome.}
\item{pos}{ a single \code{integer} representing the SNV position.}
\item{snp.allele}{ a \code{character} string representing the reference allele
and alternative allele for each of the SNV}
\item{Exon}{ a \code{character} with the ensembl GeneId(s) if the SNV is in
one exon. If more than one GeneId they are separted by ':'}
\item{GName}{ a \code{character} with the ensembl GeneId(s) if the SNV is in
the gene. If more than one GeneId they are separted by ':'}
\item{Gene}{ a single \code{integer} specific  to the SNVs that share
at least one genes}
\item{GeneS}{ a single \code{integer} specific  to the SNVs that share
a unique combination of genes}
}
"chr", "pos", "snp.allele", "Exon", "GName", "Gene", "GeneS"
Example for GName and the two indexes "Gene", "GeneS"
GName Gene GeneS
470                                 ENSG00000230021   17  3820
471                                 ENSG00000230021   17  3820
472                 ENSG00000230021:ENSG00000228794   17  3825
473                 ENSG00000230021:ENSG00000228794   17  3825
481 ENSG00000230021:ENSG00000228794:ENSG00000225880   17  3826
482 ENSG00000230021:ENSG00000228794:ENSG00000225880   17  3826
483 ENSG00000230021:ENSG00000228794:ENSG00000225880   17  3826
492                 ENSG00000230021:ENSG00000228794   17  3825
493                 ENSG00000230021:ENSG00000228794   17  3825
}
\description{
Generate two indexes based on gene annotation for
gdsAnnot1KG block
}
\examples{

## Required library
library(SNPRelate)

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## Required library
if (requireNamespace("EnsDb.Hsapiens.v86", quietly=TRUE)) {

    ## Making a "short cut" on the ensDb object
    edb <- EnsDb.Hsapiens.v86::EnsDb.Hsapiens.v86

    path1KG <- file.path(dataDir, "tests")

    ## Reference GDS file
    fileReferenceGDS  <- file.path(path1KG, "ex1_good_small_1KG.gds")

    \donttest{
        ## Open the reference GDS file (demo version)
        gds1KG <- snpgdsOpen(fileReferenceGDS)

        ## The function returns a data.frame containing
        ## gene block information
        matGeneBlock <- RAIDS:::generateGeneBlock(gdsReference=gds1KG,
                            ensDb=edb)
        print(head(matGeneBlock[grep("ENSG00000157152",
                            matGeneBlock$GName),]))

        closefn.gds(gds1KG)
    }
}

}
\author{
Pascal Belleau, Astrid Deschênes and Alex Krasnitz
}
\keyword{internal}
