% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process1KG.R
\encoding{UTF-8}
\name{getRefSuperPop}
\alias{getRefSuperPop}
\title{Extract the from the 1KG GDS 'sample.ref' node
for the reference profiles (real ancestry assignation)}
\usage{
getRefSuperPop(fileReferenceGDS)
}
\arguments{
\item{fileReferenceGDS}{a \code{character} string representing the file
name of the Reference GDS file. The file must exist.}
}
\value{
\code{vector} of \code{character} strings representing the content
of the extracted column for the 1KG GDS 'sample.ref' node. The values
represent the known ancestry assignation. The profile
identifiers are used as names for the \code{vector}.
}
\description{
The function extract the specified column for the 'sample.ref'
node present in the Reference GDS file. The column must be present in the
\code{data.frame} saved in the 'sample.ref' node. Only the information for
the reference profiles is returned. The values
represent the known ancestry assignation.
}
\examples{


## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## Open existing demo 1K GDS file with "sample.ref" node
nameFileGDS <- file.path(dataDir, "PopulationReferenceDemo.gds")

## Extract super population information for the 1KG profiles
getRefSuperPop(fileReferenceGDS=nameFileGDS)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
