% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateEstimateAllelicFraction}
\alias{validateEstimateAllelicFraction}
\title{Validate input parameters for estimateAllelicFraction() function}
\usage{
validateEstimateAllelicFraction(
  gdsReference,
  gdsProfile,
  currentProfile,
  studyID,
  chrInfo,
  studyType,
  minCov,
  minProb,
  eProb,
  cutOffLOH,
  cutOffHomoScore,
  wAR,
  cutOffAR,
  gdsRefAnnot,
  blockID,
  verbose
)
}
\arguments{
\item{gdsReference}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the Population Reference GDS file.}

\item{gdsProfile}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the Profile GDS file.}

\item{currentProfile}{a \code{character} string corresponding to
the sample identifier as used in \code{\link{pruningSample}} function.}

\item{studyID}{a \code{character} string corresponding to the name of
the study as
used in \code{\link{pruningSample}} function.}

\item{chrInfo}{a \code{vector} of \code{integer} values representing
the length of the chromosomes.}

\item{studyType}{a \code{character} string representing the type of study.
The possible choices are: "DNA" and "RNA". The type of study affects the
way the estimation of the allelic fraction is done. Default: \code{"DNA"}.}

\item{minCov}{a single positive \code{integer} representing the minimum
required coverage.}

\item{minProb}{a single positive \code{numeric} between 0 and 1 that
represents the probability that the genotype is correct.}

\item{eProb}{a single \code{numeric} between 0 and 1 representing the
probability of sequencing error.}

\item{cutOffLOH}{a single \code{numeric} representing the cutoff, in log,
for the homozygote score to assign a region as LOH.}

\item{cutOffHomoScore}{a single \code{numeric} representing the cutoff, in
log, that the SNVs in a block are called homozygote by error.}

\item{wAR}{a single positive \code{integer} representing the size-1 of
the window used to compute an empty box.}

\item{cutOffAR}{a single \code{numeric} representing the cutoff, in
log score, that the SNVs in a gene are allelic fraction different from 0.5.}

\item{gdsRefAnnot}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the1 Population Reference SNV Annotation GDS file.
This parameter is RNA specific.}

\item{blockID}{a \code{character} string corresponding to the block
identifier in \code{gdsRefAnnot}. This parameter is RNA specific.}

\item{verbose}{a \code{logicial} indicating if the function should print
message when running.}
}
\value{
The integer \code{0L} when successful.
}
\description{
This function validates the input parameters for the
\code{\link{estimateAllelicFraction}} function.
}
\examples{


## Required library
library(gdsfmt)

## Directory where demo GDS files are located
dataDir <- system.file("extdata", package="RAIDS")

## The 1KG Population Reference GDS Demo file (opened)
gds1KG <- openfn.gds(file.path(dataDir,
                "PopulationReferenceDemo.gds"), readonly=TRUE)

## The GDS Sample (opened)
gdsSample <- openfn.gds(file.path(dataDir,
                    "GDS_Sample_with_study_demo.gds"), readonly=TRUE)

## Required library for this example to run correctly
if (requireNamespace("Seqinfo", quietly=TRUE) &&
     requireNamespace("BSgenome.Hsapiens.UCSC.hg38", quietly=TRUE)) {

    ## Chromosome length information
    ## chr23 is chrX, chr24 is chrY and chrM is 25
    chrInfo <- Seqinfo::seqlengths(BSgenome.Hsapiens.UCSC.hg38::Hsapiens)[1:25]

    ## The validation should be successful
    RAIDS:::validateEstimateAllelicFraction(gdsReference=gds1KG,
        gdsProfile=gdsSample,
        currentProfile="Sample01", studyID="Synthetic", chrInfo=chrInfo,
        studyType="DNA", minCov=10L, minProb=0.03, eProb=0.002, cutOffLOH=10,
        cutOffHomoScore=11, wAR=2, cutOffAR=10, gdsRefAnnot=gds1KG,
        blockID="1", verbose=FALSE)

    ## All GDS file must be closed
    closefn.gds(gdsfile=gds1KG)
    closefn.gds(gdsfile=gdsSample)

}

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
