% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_NBjacobianRow.R
\name{NBjacobianRow}
\alias{NBjacobianRow}
\title{A jacobian function of the NB for the row scores}
\usage{
NBjacobianRow(
  beta,
  X,
  reg,
  thetas,
  muMarg,
  k,
  n,
  p,
  rowWeights,
  nLambda,
  rMatK,
  preFabMat,
  Jac,
  allowMissingness,
  naId
)
}
\arguments{
\item{beta}{a vector of of length n + k +1 regression parameters to optimize}

\item{X}{the data matrix of dimensions nxp}

\item{reg}{a 1xp regressor matrix: outer product of column scores and psis}

\item{thetas}{nxp matrix with the dispersion parameters
(converted to matrix for numeric reasons)}

\item{muMarg}{an nxp offset matrix}

\item{k}{a scalar, the dimension of the RC solution}

\item{n}{a scalar, the number of samples}

\item{p}{a scalar, the number of taxa}

\item{rowWeights}{a vector of length n, the weights used for the restrictions}

\item{nLambda}{an integer, the number of lagrangian multipliers}

\item{rMatK}{the lower dimension row scores}

\item{preFabMat}{a prefab matrix, (1+X/thetas)}

\item{Jac}{an empty Jacobian matrix}

\item{allowMissingness}{A boolean, are missing values present}

\item{naId}{The numeric index of the missing values in X}
}
\value{
a symmetric jacobian matrix of size n+k + 1
}
\description{
A jacobian function of the NB for the row scores
}
