% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networks.R
\name{getNetworkSuid}
\alias{getNetworkSuid}
\title{Get the SUID of a network}
\usage{
getNetworkSuid(title = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{title}{(optional) Name of the network; default is "current" network. If
an SUID is provided, then it is validated and returned.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
(\code{numeric}) Network suid
}
\description{
Retrieve the SUID of a network
}
\examples{
\donttest{
getNetworkSuid()
getNetworkSuid("myNetwork")
# 80
}
}
\author{
Alexander Pico
}
