% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{setaCLR}
\alias{setaCLR}
\title{Centered Log-Ratio (CLR) Transform
Applies a CLR transform to a matrix of counts.
Samples should be in rows and taxa (cell types) in columns.
For each sample, the transform computes
\eqn{\mathrm{CLR}(x)_i = \log \big( (x_i + c) / g(x + c) \big)},
where \eqn{g(x + c)} is the geometric mean of the row.}
\usage{
setaCLR(counts, pseudocount = 1)
}
\arguments{
\item{counts}{An integer matrix of cell-type counts with samples in rows.}

\item{pseudocount}{Numeric. Added to all entries to avoid \code{log(0)}. Default is 1.}
}
\value{
A list with:
\describe{
  \item{method}{A string indicating the transform (\code{"CLR"}).}
  \item{counts}{A matrix of the same dimensions as the input after the CLR transform.}
}
}
\description{
Centered Log-Ratio (CLR) Transform
Applies a CLR transform to a matrix of counts.
Samples should be in rows and taxa (cell types) in columns.
For each sample, the transform computes
\eqn{\mathrm{CLR}(x)_i = \log \big( (x_i + c) / g(x + c) \big)},
where \eqn{g(x + c)} is the geometric mean of the row.
}
\details{
The CLR transform is defined sample-wise as
\deqn{\mathrm{CLR}(x)_{ij} = \log \big( (x_{ij} + c) / g_i \big),}
where
\deqn{g_i = \exp \big( \tfrac{1}{p} \sum_{j=1}^{p} \log (x_{ij} + c) \big)}
for sample \eqn{i}, and \eqn{p} is the number of taxa. Here \eqn{c} is the pseudocount.
}
\examples{
mat <- matrix(c(1, 2, 4, 8), nrow = 2, byrow = TRUE)
colnames(mat) <- c("Taxon1", "Taxon2")
out <- setaCLR(mat, pseudocount = 0)
out$counts
}
\references{
Aitchison, J. (1982). The Statistical Analysis of Compositional Data.
\emph{Journal of the Royal Statistical Society. Series B (Methodological)}, 44(2), 139--177.
}
