% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{setaCounts}
\alias{setaCounts}
\title{Extract Taxonomic Counts from Various Single Cell Objects}
\usage{
setaCounts(obj, cell_type_col = "type", sample_col = "sample", bc_col = "bc")
}
\arguments{
\item{obj}{A long-form data.frame, Seurat object, or SingleCellExperiment object.}

\item{cell_type_col}{Column name for cell types (default "type")}

\item{sample_col}{Column name for sample IDs (default "sample")}

\item{bc_col}{Column name for barcodes (default "bc")
Use `"rownames"` to extract barcodes from row names.}
}
\value{
A sample-by-celltype matrix of counts.
}
\description{
Given a long-form \code{data.frame},
creates a type-by-sample matrix of cell counts.
Users can specify the column names for cell types, samples, and barcodes.
}
\examples{
# For a data.frame with custom column names:
set.seed(687)
df <- data.frame(
  barcode = paste0("cell", 1:10),
  cellType = sample(c("Tcell", "Bcell"), 10, TRUE),
  sampleID = sample(c("sample1","sample2"), 10, TRUE)
)
cmat <- setaCounts(df,
                   cell_type_col = "cellType",
                   sample_col = "sampleID",
                   bc_col = "barcode")
print(head(cmat))
}
