% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_bordering_cells.R
\name{identify_bordering_cells}
\alias{identify_bordering_cells}
\title{identify_bordering_cells}
\usage{
identify_bordering_cells(
  spe_object,
  reference_cell,
  feature_colname = "Cell.Type",
  ahull_alpha = NULL,
  n_to_exclude = 10,
  plot_final_border = TRUE
)
}
\arguments{
\item{spe_object}{SpatialExperiment object in the form of the output of
\code{\link{format_image_to_spe}}.}

\item{reference_cell}{String. Cells of this cell type will be used for border
detection.}

\item{feature_colname}{String that specifies the column of `reference_cell`.}

\item{ahull_alpha}{Number specifying the parameter for the alpha hull
algorithm. The larger the number, the more cells will be included in one
cell cluster.}

\item{n_to_exclude}{Integer. Clusters with cell count under this number will
be deleted.}

\item{plot_final_border}{Boolean if plot the identified bordering cells.}
}
\value{
A new SPE object is returned. The SPE object has a `Region` column
  with "Border", "Inside" and "Outside" categories. The returned object also
  has an attribute saving the number of clusters.
}
\description{
Identify the cells bordering a group of cells of a particular
  phenotype, and calculate the number of clustered groups of this cell type.
}
\details{
The bordering cell detection algorithm is based on computing an
  alpha hull (Hemmer et al., 2020), a generalization of convex hull (Green
  and Silverman, 1979). The cells detected to be on the alpha hull are
  identified as the bordering cells.
}
\examples{
spe_border <- identify_bordering_cells(SPIAT::defined_image,
reference_cell = "Tumour", feature_colname = "Cell.Type", n_to_exclude = 10)
n_clusters <- attr(spe_border, "n_of_clusters") # get the number of clusters
n_clusters
}
