% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{atac}
\alias{atac}
\title{Example single-cell ATAC-seq differential accessibility data}
\format{
A data frame or \code{GRanges}-like object with the following required columns:
\describe{
\item{region_id}{Unique identifier of the region (e.g., \code{chr1-5000-5800}).}
\item{avg_log2FC}{Average log2 fold-change of accessibility for the peak in the specific cell type}
\item{p_val_adj}{Adjusted p-value (e.g., \code{FDR-corrected})}
\item{cell_type}{Cell type or cluster label associated with each measurement (e.g., \code{Acinar})}
}
}
\source{
Precomputed using \code{FindMarkers()} (Wilcoxon test, via Presto if available) on control samples
from the Human Pancreas Analysis Program (HPAP), using paired snATAC-seq and snRNA-seq data
from three non-diabetic human donors.
}
\usage{
data(atac)
}
\description{
A toy example dataset representing single-cell ATAC-seq differential accessibility results.
Each row corresponds to a chromatin accessibility peak tested for
differential accessibility across one or more cell types.
The dataset is formatted as a list of \code{GRanges} objects or
data frames (convertible to \code{GRanges}),  where each element represents
differential accessibility statistics for a specific cell type.
Multiple rows may exist per peak, each representing results in a different cell type.
}
\keyword{datasets}
