## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    fig.width = 6,
    fig.height = 4
)
suppressPackageStartupMessages({
    library(SpaceTrooper)
    library(SpatialExperiment)
})

## ----cosmx-path---------------------------------------------------------------
cospath <- system.file(file.path("extdata", "CosMx_DBKero_Tiny"), package="SpaceTrooper")
cospath

## ----cosmx-route-a------------------------------------------------------------
spe_cos <- readCosmxSPE(
    dirName=cospath,
    sampleName="DBKero_Tiny",
    coordNames=c("CenterX_global_px", "CenterY_global_px"),
    countMatFPattern="exprMat_file.csv",
    metadataFPattern="metadata_file.csv",
    polygonsFPattern="polygons.csv",
    fovPosFPattern="fov_positions_file.csv",
    fovdims=c(xdim=4256, ydim=4256)
)
spe_cos

## ----cosmx-route-a-inspect----------------------------------------------------
assayNames(spe_cos)
dim(spe_cos)
head(colnames(spatialCoords(spe_cos)))
metadata(spe_cos)$technology
metadata(spe_cos)$polygons

## ----cosmx-protein, eval=FALSE------------------------------------------------
# protfolder <- system.file("extdata", "S01_prot", package = "SpaceTrooper")
# spe_cos_prot <- readCosmxProteinSPE(
#     dirName=protfolder,
#     sampleName="cosmx_prots",
#     coordNames=c("CenterX_global_px", "CenterY_global_px"),
#     countMatFPattern="exprMat_file.csv",
#     metadataFPattern="metadata_file.csv",
#     polygonsFPattern="polygons.csv",
#     fovPosFPattern="fov_positions_file.csv",
#     fovdims=c(xdim=4256, ydim=4256)
# )
# metadata(spe_cos_prot)$technology

## ----cosmx-route-b------------------------------------------------------------
spe_cos_raw <- SpatialExperimentIO::readCosmxSXE(
    dirName=cospath,
    returnType="SPE",
    countMatPattern="exprMat_file.csv",
    metaDataPattern="metadata_file.csv",
    coordNames=c("CenterX_global_px", "CenterY_global_px"),
    addFovPos=TRUE,
    fovPosPattern="fov_positions_file.csv",
    altExps=NULL,
    addParquetPaths=FALSE
)
spe_cos_std<-updateCosmxSPE(
    spe=spe_cos_raw,
    dirName=cospath,
    sampleName="DBKero_Tiny",
    polygonsFPattern="polygons.csv",
    fovdims=c(xdim=4256, ydim=4256)
)
identical(spe_cos_std, spe_cos)

## ----xenium-path--------------------------------------------------------------
xepath <- system.file("extdata", "Xenium_small", package = "SpaceTrooper")
xepath

## ----xenium-route-a-----------------------------------------------------------
spe_xen_a <- readXeniumSPE(
    dirName=xepath,
    type="HDF5",
    coordNames=c("x_centroid", "y_centroid"),
    boundariesType="parquet",
    computeMissingMetrics=TRUE,
    keepPolygons=TRUE,
    countsFilePattern="cell_feature_matrix",
    metadataFPattern="cells.csv.gz",
    polygonsFPattern="cell_boundaries",
    polygonsCol="polygons",
    txPattern="transcripts",
    addFOVs=FALSE
)
spe_xen_a

## ----xenium-route-a-inspect---------------------------------------------------
assayNames(spe_xen_a)
dim(spe_xen_a)
colnames(spatialCoords(spe_xen_a))
metadata(spe_xen_a)$polygons
metadata(spe_xen_a)$technology

## ----xenium-route-b-----------------------------------------------------------
spe_xen_b <- SpatialExperimentIO::readXeniumSXE(
    dirName=xepath,
    countMatPattern="cell_feature_matrix.h5",
    metaDataPattern="cells.csv.gz",
    coordNames=c("x_centroid", "y_centroid"),
    returnType="SPE",
    addExperimentXenium=FALSE,
    altExps=NULL,
    addParquetPaths=FALSE
)
spe_xen_b <- updateXeniumSPE(
    spe=spe_xen_b,
    dirName=xepath,
    boundariesType="parquet",
    computeMissingMetrics=TRUE,
    keepPolygons=TRUE,
    polygonsFPattern="cell_boundaries",
    polygonsCol="polygons",
    txPattern="transcripts",
    addFOVs=FALSE
)
spe_xen_b

## ----xenium-route-b-validate--------------------------------------------------
identical(metadata(spe_xen_b)$technology, "10X_Xenium")
identical(spe_xen_a, spe_xen_b)

## ----session-info-------------------------------------------------------------
sessionInfo()

