% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{computeQCScoreFlags}
\alias{computeQCScoreFlags}
\title{computeQCScoreFlags}
\usage{
computeQCScoreFlags(spe, qsThreshold = 0.5, useQSQuantiles = FALSE)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with spatial transcriptomics data.}

\item{qsThreshold}{Numeric threshold or quantile for quality score. Default
`0.5`.}

\item{useQSQuantiles}{Logical; if `TRUE`, treat `qsThreshold` as a
percentile.}
}
\value{
The `SpatialExperiment` object with added filter flags in `colData`.
}
\description{
Compute flagged cells based on a manually chosen threshold on quality score

This function Compute flagged cells based on a manually chosen threshold on
quality score stored in `SpatialExperiment` object.
}
\examples{
example(computeQCScore)
spe <- computeQCScoreFlags(spe)
table(spe$low_qcscore)
# if fixed filters are defined we have an additional column
spe <- computeThresholdFlags(spe)
spe <- computeQCScoreFlags(spe)
table(spe$low_threshold_qcscore)
}
