% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{TB_hiv}
\alias{TB_hiv}
\title{An example TB dataset with TB/HIV data.}
\format{
SummarizedExperiment
}
\usage{
TB_hiv
}
\description{
An example dataset containing the gene expression and metadata in a
SummarizedExperiment object for 31 subjects with HIV and/or Tuberculosis
diseases. Information on subject infection status can be accessed with
\code{TB_hiv$Disease}. Samples with both TB and HIV contamination are
marked as \code{tb_hiv}, while samples with HIV and no TB are marked
as \code{hiv_only}.
}
\details{
This dataset was published as part of a study to assess whether gene expression
signatures and cytokine levels would distinguish active TB in advanced HIV
in a cohort residing in Sub-Saharan Africa (Verma et. al 2018).
Participants were severely immunosuppressed TB-HIV patients who had
not yet received TB treatment or anti-retroviral therapy (ART). The dataset included
in this package has been lightly edited from the originally published dataset
due to the removal of one participant who was HIV positive, on ART and developed
TB during follow-up. Whole blood RNA-Seq analysis was performed on all
31 participants.
}
\examples{
data("TB_hiv")
}
\references{
Verma S., Du P., et. al. (2018). Tuberculosis in advanced HIV infection is
associated with increased expression of IFN and its downstream targets.
\emph{BMC Infectious Diseases} \strong{18:220}.
doi: \url{https://doi.org/10.1186/s12879-018-3127-410.1186/s12879-018-3127-4}.
}
\keyword{datasets}
