% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OriginalModel.R
\name{evaluateOriginalModel}
\alias{evaluateOriginalModel}
\title{A function that implements the original methods for multiple TB signatures.}
\usage{
evaluateOriginalModel(
  input,
  geneSignaturesName,
  useAssay = 1,
  adj = 0.001,
  BPPARAM = BiocParallel::SerialParam(progressbar = TRUE)
)
}
\arguments{
\item{input}{A SummarizedExperiment object with gene symbols as the assay row
names.}

\item{geneSignaturesName}{A character string/vector specifying the signature
of interest. If \code{any(geneSignaturesName == "") == TRUE}, it will run all
available gene signatures' original models.}

\item{useAssay}{A character string or an integer specifying the assay in the
\code{input}. Default is the first assay in the assay list.
Used for the test SummarizedExperiment object. Default is \code{1}, indicating the
first assay in the \code{input}.}

\item{adj}{A small positive real number used in \code{\link[sva]{ComBat}} to solve
for genes with 0 counts(rare cases). Default is \code{1e-3}.}

\item{BPPARAM}{An instance inherited from \code{\link[BiocParallel]{bplapply}}.}
}
\value{
A SummarizedExperiment object with predicted scores for each sample
obtained from the signature's original model.
}
\description{
This function computes prediction for multiple TB signatures based on their training
models/methods. To avoid naming issues, the gene names for both training data and
input gene sets have been updated using the \code{\link[HGNChelper]{checkGeneSymbols}}.
TB signatures with available original models are: Anderson_42,
Anderson_OD_51, Kaforou_27, Kaforou_OD_44, Kaforou_OD_53, Sweeney_OD_3,
Maertzdorf_4, Verhagen_10, Jacobsen_3, Sambarey_HIV_10, Leong_24,
Berry_OD_86, Berry_393, Bloom_OD_144, Suliman_RISK_4, Zak_RISK_16,
Leong_RISK_29, and Zhao_NANO_6.
The predicted score for each signature has been stored in the column data
section of the input SummarizedExperiment study.
}
\examples{
re <- evaluateOriginalModel(input = TB_indian,
                            geneSignaturesName = c("Anderson_42"),
                            useAssay = "counts")
re$Anderson_42_OriginalModel

}
