% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{mkAssay}
\alias{mkAssay}
\title{Add SummarizedExperiment assays to the data structure.}
\usage{
mkAssay(
  SE_obj,
  input_name = "counts",
  output_name = NULL,
  log = FALSE,
  counts_to_CPM = TRUE,
  prior_counts = 3
)
}
\arguments{
\item{SE_obj}{a \code{SummarizedExperiment} object containing count or CPM
data. Required.}

\item{input_name}{a character string specifying the name of the assay to
be referenced for creating additional assays. Default is \code{"counts"}.}

\item{output_name}{a character string to use in place of the \code{input_name}.
If \code{NULL}, then \code{input_name} will be substituted.
Default is \code{NULL}. See Return details for how names are altered.}

\item{log}{logical. Indicate whether an assay returned should be the log
of whichever assay is specified in \code{"output_name"}. If
\code{counts_to_CPM = TRUE} as well, then a log CPM assay will also
be created. Default is \code{FALSE}.}

\item{counts_to_CPM}{logical. This argument only applies if the
\code{input_type} is a counts assay. If \code{TRUE}, then the output assays
will include a normalized CPM assay. If \code{log = TRUE} as well,
then a log CPM assay will also be created. Default is \code{TRUE}.}

\item{prior_counts}{a small integer specifying the average count to be added to
each observation to avoid taking the log of zero. Used only if
\code{log = TRUE}. The default is \code{3}.}
}
\value{
This function returns a \code{SummarizedExperiment} object with up
to 3 additional assay types attached to the original inputted object.
\item{\code{output_name}_cpm}{Counts per million}
\item{log_\code{output_name}_cpm}{Log counts per million}
\item{log_\code{output_name}}{Log of original input assay.}
}
\description{
Given a \code{SummarizedExperiment} input with a counts or CPM assay, this
function creates additional assays for by computing the CPM, log, or both
of the input assay to be used in further analysis.
}
\examples{
# Create a log assay of the original assay input
# TB_hiv dataset already has counts data
log_only <- mkAssay(TB_hiv, log = TRUE, counts_to_CPM = FALSE)
log_only

# Create a CPM assay
CPM_only <- mkAssay(TB_hiv)
CPM_only

# Create a logCPM, logcounts, and CPM assay
all_assays <- mkAssay(TB_hiv, log = TRUE)
all_assays

}
\author{
Aubrey Odom-Mabey
}
