% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Show_database_information.R
\name{show_contained_variants_in_library}
\alias{show_contained_variants_in_library}
\title{All variants contained in reference library}
\usage{
show_contained_variants_in_library(
    ref_gen,
    library_name,
    mutational_weight_inclusion_threshold
)
}
\arguments{
\item{ref_gen}{a character vector specifying the reference genome 
version. All training sets are associated with a reference genome version. 
Default is \code{"GRCH37"}.}

\item{library_name}{Name of the reference library.}

\item{mutational_weight_inclusion_threshold}{Include only mutations 
with a weight of at least x. Range: 0.0 to 1.0. 1 = unique to CL. 
~0 = found in many CL samples.}
}
\value{
Returns a GenomicRanges object that contains the variants
}
\description{
This function shows all variants contained in a reference library
for a given inclusion weight. Default inclusion weight is 0 
(all variants).
}
\examples{
## Show all variants contained in reference library CELLMINER
show_contained_variants_in_library(
    ref_gen = "GRCH37",
    library_name = "CELLMINER",
    mutational_weight_inclusion_threshold = 0
)
}
