% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersect.R
\name{annotate_regions}
\alias{annotate_regions}
\title{A function to intersect user region data with annotation data}
\usage{
annotate_regions(
  regions,
  annotations,
  minoverlap = 1L,
  ignore.strand = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{regions}{The GRanges object returned by \code{read_regions()}.}

\item{annotations}{A character vector of annotations to build. Valid annotation codes are listed with \code{builtin_annotations()}. The "basicgenes" shortcut builds the following regions: 1-5Kb upstream of TSSs, promoters, 5UTRs, exons, introns, and 3UTRs. The "cpgs" shortcut builds the following regions: CpG islands, shores, shelves, and interCGI regions. NOTE: Shortcuts need to be appended by the genome, e.g. \code{hg19_basicgenes}.
Custom annotations whose names are of the form \code{[genome]_custom_[name]} should also be included. Custom annotations should be read in and converted to \code{GRanges} with \code{read_annotations()}. They can be for a \code{supported_genome()}, or for an unsupported genome.}

\item{minoverlap}{A scalar, positive integer, indicating the minimum required overlap of regions with annotations.}

\item{ignore.strand}{Logical indicating whether strandedness should be respected in findOverlaps(). Default FALSE.}

\item{quiet}{Print progress messages (FALSE) or not (TRUE).}
}
\value{
A \code{GRanges} where the \code{granges} are from the regions, and the \code{mcols} include the \code{mcols} from the regions and a column with the annotation \code{GRanges}.
}
\description{
Annotate genomic regions to selected genomic annotations while preserving the data associated with the genomic regions.
}
\examples{
   r_file = system.file('extdata', 'test_read_multiple_data_nohead.bed', package='annotatr')
   extraCols = c(pval = 'numeric', mu1 = 'integer', mu0 = 'integer', diff_exp = 'character')
   r = read_regions(con = r_file, extraCols = extraCols, rename_score = 'coverage')

   # Get premade CpG annotations
   data('annotations', package = 'annotatr')

   a = annotate_regions(
       regions = r,
       annotations = annotations,
       ignore.strand = TRUE)

}
